%{
/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "curs.hxx"

p_exe exe_output;
extern FILE *dbg_fil;
  
void yyerror(char* text) 
{
  cout << "syntax error: " << text << "\n"; 
  return;
}

void ydbg (char* info)
{
  if (dbg_fil)
    fprintf(dbg_fil,"Yac (%s)\n",info);

  return;
}

extern int yylex();
extern FILE *yyin, *yyout;

%}

/* BISON Declarations */
%union {
  p_tkn  tok;
  char   *str;
  p_crd  crd;
}  

%token <str> B 500
%token <str> IDENT 501
%token <str> TTEXT 502
%token <tok> EXECUTABLE 503
%token <tok> PARAMETERS 504
%token <tok> DESCRIPTION 505
%token <tok> OBJECT 506
%token <str> E 507
%token <str> FILTER 508

%type  <tok> exp
%type  <str> ttext
%type  <tok> exp_list
%type  <crd> block
%type  <crd> block_list


%nonassoc ':'
     

/* Grammar follows */
%%
input: /* empty string */
     | input block_list {ydbg("Input"); exe_output = new exec($2); }
;
     
block_list: block
          | block block_list { $1->next = $2; $$ = $1; }
;


block: B exp_list E { ydbg("Begin-End"); $$ = new card($2); }
     ;

exp_list: exp
        | exp exp_list { $1->next = $2; $$ = $1; }
;
     
exp: DESCRIPTION ':' ttext  { ydbg("Des"); $$ = new tkn($3, DESCRIPTION); }
   | EXECUTABLE  ':' IDENT { ydbg("Exe"); $$ = new tkn($3, EXECUTABLE); }
   | PARAMETERS  ':' ttext  { ydbg("Par"); $$ = new tkn($3, PARAMETERS); }
   | OBJECT      ':' IDENT { ydbg("Obj"); $$ = new tkn($3, OBJECT); }
   | FILTER      ':' IDENT { ydbg("Flt"); $$ = new tkn($3, FILTER); }
   | FILTER      ':' ttext { ydbg("Flt"); $$ = new tkn($3, FILTER); }
;

ttext:     { $$ = NULL; } /* empty string */
   | TTEXT { $$ = $1; }
;

%%

   

