/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "tkn.hxx"
#undef OK
#include "curs.hxx"
extern "C" {
#include <shhopt.h>
}

#define VERSION_INT 0
#define VERSION_DEC 1

int flag_debug    = 0;
int flag_help     = 0;
int flag_version  = 0;
static FILE *dbg_fil = NULL;
FILE *res_fil = NULL;
char *absscript = SCRFILE;
char *cmdscript;

static optStruct myoptions[] = {
  {'f', "file",     OPT_STRING, &cmdscript, 0 },
  {'d', "debug",    OPT_FLAG,   &flag_debug, 0 },
  {'h', "help",     OPT_FLAG,   &flag_help, 0 },
  {'v', "version",  OPT_FLAG,   &flag_version, 0 },
  {' ', " ",        OPT_END,    (void *) NULL, 0 } 
};

p_scr myscreen;

static void finish(int sig);

extern p_exe exe_output;
extern void setup_lex(FILE *, FILE*);

void usage (void)
{

   cout << "\nwebble version " << VERSION_INT << "." << VERSION_DEC << "\n\n";
   cout << "Usage: webble [options]\n\n";


   cout << "Options:\n";
   cout << "-f | --file <file> : use <file> as webble resource file\n";
   cout << "-d | --debug       : outputs debug information to webble.dbg\n";
   cout << "-h | --help        : print this help message\n";
   cout << "-v | --version     : print this help message\n";

   cout << "\n";

   finish (0);

}

static void finish(int sig)
{
  delete myscreen;

  if (dbg_fil)
    fclose(dbg_fil);

  if (res_fil)
    fclose(res_fil);

  exit(sig);
}

int main (int argc, char **argv) 
{
  char localscript[100];

  strcpy (localscript,getenv("HOME"));
  strcat (localscript,"/.webblerc");

  (void) signal (SIGINT, finish);

  optParseOptions (&argc, argv, myoptions, 0);

  if (flag_help || flag_version) {
    usage ();
    finish(0);
  }
  
  if (flag_debug)
    if (!(dbg_fil=(FILE *)fopen("./webble.dbg","w"))) {
      cout << "Could not open debug file!\n";
      finish (-1);
    }

  if (cmdscript) {
    if (!(res_fil=(FILE *)fopen(cmdscript,"r"))) {
      cout << "Could not open resource file : " << cmdscript << " !\n";
      finish (-1);
    }
  } else {
    if (!(res_fil = (FILE *) fopen( localscript, "r" )))
      if(!(res_fil = (FILE *) fopen( absscript, "r" ))) {
       cout << "Could not find resource file!\n";
       finish (-1);
      }
  }

  setup_lex(res_fil, dbg_fil);

  myscreen = new scr ();
  myscreen->set_exe(exe_output);
  myscreen->run ();
  
  finish (0);
  return 0;
}


