%{

/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>
#include <g++/iostream.h>
#include "tkn.hxx"
#include "parser.hxx"


#define yywrap() 1
#define YY_SKIP_YYWRAP 1
#define yyunput() 1
#define YY_NO_UNPUT 1

extern void yyparse(void);

FILE *dbg_fil=NULL;

void ldbg (char *info)
{
 if (dbg_fil) {
  if (info == "Not")
   fprintf(dbg_fil,"Lex (%s)\n",info);
  else
   fprintf(dbg_fil,"Lex (%s): %s\n",info,yytext);
 }
 return;
}

%}

%s block
%s bdesc
%s biden

COMMENT  #.*
NOTHING  [ \t\n]*

ID       [[:alnum:]/.\*-]*
TXT      [[:alnum:] /.\*()-]*[\n]
BBLOCK   begin[ \t]*\n
SEP      :[ \t]*
DESC     description
EXEC     executable
PARAM    parameters
FILT     filter
OBJ      object
EBLOCK   end[ \t]*\n


%%
<*>{NOTHING}+     ldbg("Not");
<*>{COMMENT}      ldbg("Com");

<INITIAL>{BBLOCK} {
                   yytext[--yyleng] = '\0';
                   BEGIN(block);
                   ldbg("Beg"); 
                   return B;
                  }

<block>{EBLOCK}   {
                   yytext[--yyleng] = '\0';
                   BEGIN(INITIAL);
                   ldbg("End");
                   return E;
                  }

<block>{DESC}     {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Des");
                   BEGIN(bdesc);
                   return DESCRIPTION;
                  }

<block>{EXEC}     {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Exe");
                   BEGIN(biden);
                   return EXECUTABLE;
                  }

<block>{PARAM}    {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Par");
                   BEGIN(bdesc);
                   return PARAMETERS;
                  }

<block>{OBJ}      {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Obj");
                   BEGIN(biden);
                   return OBJECT;
                  }

<block>{FILT}     {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Flt");
                   BEGIN(biden);
                   return FILTER;
                  }

<biden,bdesc>{SEP} {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Sep");
                   return (int) yytext[0];
                  }

<biden>{ID}       {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("ID ");
                   BEGIN(block);
                   return IDENT;
                  }

<bdesc>{TXT}      {
                   yylval.str = (char *) malloc (strlen(yytext)+1);
                   strcpy (yylval.str,yytext);
                   ldbg("Tex");
                   BEGIN(block);
                   return TTEXT;
                  }


%%

void setup_lex (FILE *input, FILE *dbgfil)
{
  dbg_fil = dbgfil;

  yyin = input;

  yyparse();

  return;

}

