/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __CURS_H__

#include <stdlib.h>
#include <math.h>
#include <signal.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include "tkn.hxx"
#ifdef __cplusplus
extern "C"{
#endif
#include "regex.h"
#ifdef __cplusplus
}
#endif

#ifndef CTRL
#define CTRL(x)		((x) & 0x1f)
#endif
#define QUIT		CTRL('Q')
#define ESCAPE		CTRL('[')
#define BLANK		' '		/* this is the background character */

#define STR_SIZE 100

#define KEY_TAB  9
#define KEY_ESC  27
#define KEY_PGUP 339
#define KEY_PGDN 338

#define REQ_EXECUTE MAX_FORM_COMMAND + 1
#define REQ_NEXT    MAX_FORM_COMMAND + 2
#define REQ_PREV    MAX_FORM_COMMAND + 3
#define REQ_EXIT    MAX_FORM_COMMAND + 4
#define REQ_SELECT  MAX_FORM_COMMAND + 5

const char WEBBLE[]=" Webble 0.1 - The Generic Launcher ";
const char STR_STATUS[]="<TAB> Next Window    <ENTER> Select    <ESC> Quit";

/* Defitions for regex */
#define MATCH 1
#define NOMATCH 0

/* Fields Definitions */
#define OPT_DIR 0
#define OPT_OPT 1
#define OPT_FLT 2
#define OPT_NUL 3

#define STX_STX 0
#define STX_NUL 1

class   scr;
typedef scr *p_scr;

extern p_scr myscreen;

int select_fil (const struct dirent *file);
void check_fld (FORM *Frm);


typedef struct {
  int x, y;
  int w, h;
  int f, b;
} ATTRIBS;

class EXEWIN {
private:
  WINDOW *W;
  ATTRIBS A;
  MENU *M;
  ITEM **I;
  scr *father;
public:
  EXEWIN(scr *dad);
  ~EXEWIN(void);
  int post(void);
  int unpost(void);
  int run(void);
  int create(p_exe ptr_exe);
  int redraw(void);
  ATTRIBS *attrib(void);
  int itemindex(void);
};  

class DIRWIN {
private:
  WINDOW *W;
  ATTRIBS A;
  MENU *M;
  ITEM **I;
  scr *father;
  int dir_entries;
  char dir[100];
  struct dirent **namelist;
public:
  DIRWIN(scr *dad);
  ~DIRWIN(void);
  int post(void);
  int unpost(void);
  int run (void);
  int select_dir (void);
  int select (const struct dirent *file);
  int check_chosen(char *new_dir);
  int redraw(void);
  ATTRIBS *attrib(void);
  char *get_dir(void);
  char *get_item(void);
  int set_dir(char *txt);
};  

class OPTIONS {
private:
  WINDOW *W;
  ATTRIBS A;
  FORM *F;
  FIELD **f;
  scr* father;
  char filter[100];
  char options[100];
  int rp;
  regex_t rt;
  int active;
  char save_txt[100];
public:
  OPTIONS(scr *dad);
  ~OPTIONS(void);
  int post(void);
  int unpost(void);
  void clean_regexp(void);
  int set_directory(char *direc);
  int set_options(char *opt);
  int set_filter(char *flt);
  int set_pattern(int ptrn);
  int redraw(void);
  int run(void);
  int form_virtualize(WINDOW *w);
  int my_form_driver(FORM *form, int c);
  void check_field(FORM *Frm);
  ATTRIBS *attrib(void);
  int regex_exec(char *filename);
  char *get_opt(void);
};

class STATUS {
private:
  WINDOW *W;
  ATTRIBS A;
  FORM *F;
  FIELD **f;
  scr *father;
  char *txt;
public:
  STATUS (scr *dad);
  ~STATUS (void);
  int post(void);
  int unpost(void);
  int set_status(char *stx);
  int redraw(void);
  int error(char *err);
  ATTRIBS *attrib(void);
};

class scr {
private:

  char executable[100];
  p_exe launch;

public:
  EXEWIN *exewin;
  DIRWIN *dirwin;
  STATUS *stxwin;
  OPTIONS *optwin;
  WINDOW *allwin;

  scr (void);
  ~scr(void);

  int run (void);
  int paint (void);
  int draw_scr(void);
  void make_border(ATTRIBS *A);
  int set_exe(p_exe pointer);
  int execute(void);
};


typedef int (*PMF)(const struct dirent *);


#define __CURS_H__
#endif
