/*  webble - generic launcher
    Copyright (C) 1998  Rubens Ramos Fernandes Junior

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "curs.hxx"

STATUS::STATUS(scr *dad) {
  int curr_x, curr_y, aux;

  father = dad;
  getmaxyx (stdscr,curr_y,curr_x);
  aux=(int)ceil(((double) curr_y - 6)/10);

  A.x = 3;
  A.w = curr_x-4;
  A.h = 1;
  A.y = curr_y-2;

  W = subwin(stdscr,A.h,A.w,A.y,A.x);
  keypad(W,TRUE);
  leaveok (W,true);

  f = new (FIELD*)[2];
  f[STX_STX] = new_field (1, A.w, 0, 0, 0, 0);
  f[STX_NUL] = NULL;

  F = new_form (f);
  set_form_win(F,W);
  set_form_sub(F,W);

  txt = new char[A.w];
}

STATUS::~STATUS(void) {
  delete [] txt;
  free_field (f[STX_STX]);
  free_form(F);
  delwin(W);
  delete [] f;
}

int STATUS::post(void) {
  return post_form(F);
}

int STATUS::unpost(void) {
  return unpost_form(F);
}

int STATUS::set_status(char *stx) {
  unpost_form(F);
  strcpy(txt,stx);
  set_field_buffer(f[STX_STX],0,stx);
  post_form(F);
  return OK;
}

int STATUS::redraw(void) {
  return wnoutrefresh(W);
}

int STATUS::error (char *err)
{
  char *error_txt = new char[strlen(err)+strlen(" <Hit a key>")+1];
  char *save_txt = new char[strlen(txt)+1];

  strcpy (save_txt,txt);
  strcpy (error_txt,err);
  strcat (error_txt," <Hit a key>");
  set_status(error_txt);
  beep();
  father->paint();
  wgetch(W);
  set_status(save_txt);
  father->paint();

  delete []error_txt;
  delete []save_txt;

  return OK;
}

ATTRIBS *STATUS::attrib(void) {
  return (&A);
}

OPTIONS::OPTIONS (scr *dad) {
  int curr_x, curr_y, aux;

  father = dad;

  getmaxyx (stdscr,curr_y,curr_x);
  aux=(int)ceil(((double) curr_y - 6)/10);

  active = 0;

  A.x = 29;
  A.w = curr_x-32;
  A.h = aux*7;
  A.y = curr_y-A.h-3;

  W = subwin(stdscr,A.h,A.w,A.y,A.x);
  keypad(W,TRUE);
  leaveok (W,TRUE);

  f = new (FIELD*)[4];
  f[OPT_DIR] = new_field (1, A.w-2, 3, 1, 0, 0);
  f[OPT_OPT] = new_field (1, A.w-2, 6, 1, 0, 0);
  f[OPT_FLT] = new_field (1, A.w-2, 9, 1, 0, 0);
  f[OPT_NUL] = NULL;

  mvwaddstr(W,2,1,"Directory:");
  mvwaddstr(W,5,1,"Options:");
  mvwaddstr(W,8,1,"Files:");

  F = new_form (f);
  set_form_win(F,W);
  set_form_sub(F,W);

  strcpy(filter,"*");

  clean_regexp();
}

OPTIONS::~OPTIONS (void) {
  int i;
  
  for (i=0; i<OPT_NUL-1; i++)
    free_field (f[i]);

  free_form(F);
  delete [] f;
  delwin(W);
}

char *OPTIONS::get_opt(void) {
  return options;
}

int OPTIONS::regex_exec(char *filename) {
  if (regexec (&rt,filename, 0, 0, 0))
    return NOMATCH;
  else
    return MATCH;
}

int OPTIONS::post(void) {
  return post_form(F);
}

int OPTIONS::unpost(void) {
  return unpost_form(F);
}

void OPTIONS::clean_regexp(void) {
  rp=RE_SYNTAX_AWK;

  rt.buffer = NULL;
  rt.allocated = 0;
  rt.used = 0;
  rt.fastmap = NULL;
  rt.fastmap_accurate = 0;
  rt.translate = NULL;
  rt.can_be_null = 0;
  rt.re_nsub = 0;
  rt.no_sub = 0;
  rt.not_bol = 0; 
  rt.not_eol = 0;
}

int OPTIONS::set_directory(char *dir) {
  char *aux = new char[strlen(dir)+2];

  if (dir)
    strcpy (aux,dir);
  else dir=NULL;

  unpost_form(F);
  if (aux[strlen(aux)-1]!='/' && strlen(aux)!=0)
    strcat(aux,"/");
  set_field_buffer(f[OPT_DIR],0,aux);
  post_form(F);
  mvwaddstr(W,2,1,"Directory:");
  mvwaddstr(W,5,1,"Options:");
  mvwaddstr(W,8,1,"Files:");

  delete [] aux;
  return OK;
}

int OPTIONS::set_options(char *opt) {
  unpost_form(F);

  if (opt)
    strcpy(options,opt);
  else opt=NULL;

  set_field_buffer(f[OPT_OPT],0,opt);
  post_form(F);
  mvwaddstr(W,2,1,"Directory:");
  mvwaddstr(W,5,1,"Options:");
  mvwaddstr(W,8,1,"Files:");
  return OK;
}

int OPTIONS::set_filter(char *flt) {
  char *aux = new char[strlen(flt)+1];
  int status = NOK;

  if (flt)
    strcpy(aux,flt);
  else flt=NULL;

  unpost_form(F);
  if (!regcomp (&rt,aux,rp)) {
    status = OK;
    strcpy(filter,flt);
    set_field_buffer(f[OPT_FLT],0,flt);
  }
  post_form(F);
  mvwaddstr(W,2,1,"Directory:");
  mvwaddstr(W,5,1,"Options:");
  mvwaddstr(W,8,1,"Files:");
  delete [] aux;

  return status;
}

int OPTIONS::set_pattern(int ptrn) {
  rp=ptrn;
  return OK;
}

int OPTIONS::redraw(void) {
  return wnoutrefresh(W);
}

int OPTIONS::run(void) {
  int key, finished=0, i;
  
  for (i=0; i<2; i++) {
    field_opts_off (f[i],O_STATIC);
    field_opts_off (f[i],O_AUTOSKIP);
    field_opts_off (f[i],O_WRAP);
    field_opts_off (f[i],O_BLANK);
    field_opts_on (f[i],O_PUBLIC);
    field_opts_on (f[i],O_ACTIVE);
  }
  form_driver (F,REQ_FIRST_FIELD);
  form_driver (F,REQ_INS_MODE);
  set_field_term(F,check_fld);

  leaveok(W, FALSE);

  active = 1;
  while (!finished)
    {
      strcpy(save_txt,field_buffer(current_field(F),0));
      switch(form_driver(F, key = form_virtualize(W)))
	{
	case E_OK:
	  break;
	case E_UNKNOWN_COMMAND:
	  finished = my_form_driver(F, key);
	  break;
	default:
	  beep();
	  break;
	}
    }

  set_field_term(F,NULL);

  leaveok(W, TRUE);
  active = 0;

  if (key==REQ_EXIT) {
    father->dirwin->unpost();
    father->stxwin->set_status("^,v-Move enter,>-Select q/esc-Quit");
    father->dirwin->set_dir("");
    set_filter("");
    set_options("");
    father->paint();
  }

  return (key);
}

int OPTIONS::form_virtualize(WINDOW *w) {
  static int	mode = REQ_INS_MODE;
  int		c = wgetch(w);

  switch(c) {
  case QUIT:
  case ESCAPE:
    leaveok(W, TRUE);
    return(REQ_EXIT);
    
  case KEY_TAB:
    if (current_field(F)==f[OPT_FLT]) {
      form_driver(F,REQ_NEXT_FIELD);
      return(REQ_NEXT);
    }
    else
      return(REQ_NEXT_FIELD);
    
  case KEY_A1:
  case KEY_HOME:
    return(REQ_BEG_FIELD);
  case KEY_C1:
  case KEY_END:
    return(REQ_END_FIELD);
    
  case KEY_LEFT:
    return(REQ_LEFT_CHAR);
  case KEY_RIGHT:
    return(REQ_RIGHT_CHAR);
    
  case KEY_DC:
    return(REQ_DEL_CHAR);
    
  case CTRL('H'):
  case KEY_BACKSPACE:
    return(REQ_DEL_PREV);
    
  case KEY_IC:
    if (mode == REQ_INS_MODE)
      return(mode = REQ_OVL_MODE);
    else
      return(mode = REQ_INS_MODE);
    
  default:
    return(c);
  }
}

int OPTIONS::my_form_driver(FORM *form, int c) {
  if (c >= (MAX_FORM_COMMAND + 1)
      && form_driver(form, REQ_VALIDATION) == E_OK)
    return(TRUE);
  else
    {
      beep();
      return(FALSE);
    }
}

void OPTIONS::check_field(FORM *Frm) {
  char aux[100], *ptr;

  if (active) {
    int index = field_index(current_field(Frm));
    switch (index) {
    case OPT_DIR:
      strcpy(aux,field_buffer(current_field(F),0));
      ptr = &aux[strlen(aux)];
      while (ptr != aux && *(--ptr) == ' ')
	*ptr = '\0';
      
      if (strcmp(aux,father->dirwin->get_dir())) {
	if ((ptr = strchr(aux,' '))) {
	  ptr[0] = '\0';
	  ptr--;
	  if (ptr[0]!='/')
	    strcat(aux,"/");
	}
	switch (father->dirwin->check_chosen(aux)) {
	case OK:
	  set_directory(aux);
	  father->dirwin->set_dir(aux);
	  father->dirwin->select_dir();
	  father->paint();
	  return;
	case REQ_SELECT:
	case NOK:
	  father->stxwin->error("invalid directory name!");
	  set_directory(save_txt);
	  father->dirwin->set_dir(save_txt);
	  return;
	}
      }
      break;
    case OPT_FLT:
      strcpy(aux,field_buffer(current_field(F),0));
      ptr = &aux[strlen(aux)];
      while (ptr != aux && *(--ptr) == ' ')
	*ptr = '\0';

      if (strcmp(aux,father->dirwin->get_dir())) {
	if ((ptr = strchr(aux,' ')))
	  ptr[0] = '\0';
	if (set_filter(aux)==NOK)
	  father->stxwin->error ("Invalid Regex expression!");
	else {
	  father->dirwin->select_dir();
	  father->paint();
	}
      }
      break;
    case OPT_OPT:
      strcpy(aux,field_buffer(current_field(F),0));
      ptr = &aux[strlen(aux)];
      while (ptr != aux && *(--ptr) == ' ')
	*ptr = '\0';

      if (set_options(aux)==NOK)
	set_current_field(F,f[OPT_OPT]);
      break;
    }
  }
  return;
}

ATTRIBS *OPTIONS::attrib(void) {
  return (&A);
}


DIRWIN::DIRWIN(scr *dad) {
  int curr_x, curr_y, aux;

  father = dad;
  getmaxyx (stdscr,curr_y,curr_x);
  aux=(int)ceil(((double) curr_y - 6)/10);

  A.h = aux*7;
  A.y = curr_y-A.h-3;
  A.x = 3;
  A.w = 25;

  W = subwin(stdscr,A.h,A.w,A.y,A.x);
  keypad(W,TRUE);
  leaveok (W,true);

  M = NULL;
  I = NULL;
}

DIRWIN::~DIRWIN (void) {
  int i, j;

  if (M) {
    j = item_count(M);
    unpost_menu(M);
    free_menu (M);
    for (i=0; i<j; i++)
     free_item(I[i]);
    delete [] I;
  }

  if (namelist)
    free (namelist);
  delwin(W);
}

int DIRWIN::post(void) {
  return post_menu(M);
}

int DIRWIN::unpost(void) {
  return unpost_menu(M);
}

char *DIRWIN::get_dir(void) {
  return dir;
}

char *DIRWIN::get_item(void) {
  return (char *) item_name(current_item(M));
}

int DIRWIN::set_dir(char *txt) {
  strcpy (dir,txt);
  return OK;
}

int DIRWIN::run (void) {
  int a,b;
  char new_dir[100];

  for (;;)
    {
      int c = wgetch(W);
      switch (c)
	{
	case KEY_UP:
	  if (item_index(current_item(M))==0)
	    menu_driver (M,REQ_LAST_ITEM);
	  else
	    menu_driver (M,REQ_PREV_ITEM);
	  break;

	case KEY_DOWN:
	  if (item_index(current_item(M))==item_count(M)-1)
	    menu_driver (M,REQ_FIRST_ITEM);
	  else
	    menu_driver (M,REQ_NEXT_ITEM);
	  break;

	case KEY_ENTER:
	case 0x0D: /* 13 - CR */
	case KEY_RIGHT:
	case ' ':
	  /* strange behaviour- case 0x1B: 27 - ESC */
	  strcpy (new_dir, dir);
	  strcat (new_dir, "/");
	  strcat (new_dir, item_name(current_item(M)));
	  switch (check_chosen(new_dir)) {
	  case REQ_SELECT:
	    return REQ_SELECT;
	    break;
	  case OK:
	    set_dir(new_dir);
	    father->optwin->set_directory(new_dir);
	  case NOK:
	    select_dir();
	  }

	case KEY_A1:
	case KEY_HOME:
	  menu_driver (M,REQ_FIRST_ITEM);
	  break;

	case KEY_C1:
	case KEY_END:
	  menu_driver (M,REQ_LAST_ITEM);
	  break;

	case KEY_TAB:
	  return REQ_NEXT;
	  break;

	case KEY_NPAGE:
	case KEY_C3:
	  menu_format (M,&a, &b);
	  b = item_index(current_item(M));
	  if ((a+b) < item_count(M))
	    for (b=0; b<a; b++)
	      menu_driver(M,REQ_NEXT_ITEM);
	  else
	    menu_driver (M,REQ_LAST_ITEM);	    
	  break;

	case KEY_PPAGE:
	case KEY_A3:
	  menu_format (M,&a, &b);
	  b = item_index(current_item(M));
	  if ((b-a) > 0)
	    for (b=0; b<a; b++)
	      menu_driver(M,REQ_PREV_ITEM);
	  else
	    menu_driver (M,REQ_FIRST_ITEM);
	  break;

	case KEY_LEFT:
	case KEY_ESC:

	  unpost_menu(M);
	  father->stxwin->set_status("^,v-Move enter,>-Select q/esc-Quit");
	  father->optwin->set_directory("");
	  father->optwin->set_filter("");
	  father->optwin->set_options("");
	  father->paint();
	  return REQ_EXIT;
	  
	default:
	  break;
	}
      father->paint();
    }
  return OK;
}

int DIRWIN::select_dir (void) {
  int i, j, err=OK;

  chdir(dir);
  getcwd(dir,100);
  father->optwin->set_directory(dir);

  if (M) {
    j = item_count(M);
    unpost_menu(M);
    free_menu (M);
    for (i=0; i<j; i++)
     free_item(I[i]);
    delete [] I;
  }

  if (namelist)
    free (namelist);


  dir_entries=scandir(dir,&namelist,select_fil,alphasort);

  if (dir_entries < 0) {
    dir_entries = 2;
    I = new (ITEM*)[dir_entries+1];
    I[dir_entries] = NULL;
    
    I[0] = new_item(".","error");
    I[1] = new_item("..","error");
    father->stxwin->error("Could not read directory!");
    namelist=NULL;
    err=NOK;
  }
  else {
    I = new (ITEM*)[dir_entries+1];
    I[dir_entries] = NULL;
    
    for (i=0; i<dir_entries; i++)
      I[i] = new_item(namelist[i]->d_name,"");
  }

  father->dirwin->set_dir(dir);
  M = new_menu(I);
  set_menu_win(M,W);
  set_menu_sub(M,W);
  set_menu_format(M,A.h,1);
  post_menu(M);
  menu_driver (M,REQ_FIRST_ITEM);

  return err;
}

int DIRWIN::select (const struct dirent *file) {
  struct stat filebuf;
  char *filename;
  char curr_dir[100];

  getcwd(curr_dir,100);
  strcat(curr_dir,"/");

  filename=new char[strlen(file->d_name)+strlen(curr_dir)+1];
  strcpy(filename,curr_dir);
  strcat(filename,file->d_name);

  stat (filename, &filebuf);

  if ((filebuf.st_mode & S_IFMT)==S_IFDIR||(filebuf.st_mode & S_IFMT)==S_IFLNK)
    return MATCH;

  delete [] filename;

  return father->optwin->regex_exec((char *)file->d_name);
}

int DIRWIN::check_chosen(char *new_dir) {
  int retval = OK;
  struct stat filebuf;
  char *aux = new char[strlen(new_dir)+2];
  char *old_dir;
  int a = strlen(new_dir)-1;

  old_dir = getcwd(NULL,100);
  strcpy (aux,new_dir);
  if (aux[a]=='/' && a!=0)
    aux[a]='\0';

  stat (aux, &filebuf);
  strcat (aux, "/");

  if ((filebuf.st_mode & S_IFMT)==S_IFDIR||(filebuf.st_mode & S_IFMT)==S_IFLNK)
    if (!chdir(aux)) {
      chdir(old_dir);
      retval = OK;
    } else {
      father->stxwin->error ("cannot open directory!");
      retval = NOK;
    }
  else retval = REQ_SELECT;

  delete [] aux;
  free (old_dir);

  return retval;
}

int DIRWIN::redraw(void) {
  return wnoutrefresh(W);
}

ATTRIBS *DIRWIN::attrib(void) {
  return (&A);
}

EXEWIN::EXEWIN(scr *dad) {
  int curr_x, curr_y, aux;

  father = dad;

  getmaxyx (stdscr,curr_y,curr_x);
  aux=(int)ceil(((double) curr_y - 6)/10);

  A.y = 2;
  A.x = 3;
  A.w = curr_x-6;
  A.h = curr_y-(aux*7)-7;

  W = subwin(stdscr,A.h,A.w,A.y,A.x);
  keypad(W,TRUE);
  leaveok (W,true);

  M = NULL;
  I = NULL;

}

EXEWIN::~EXEWIN(void) {
  delwin(W);
}

int EXEWIN::itemindex(void) {
  return item_index(current_item(M));
}

int EXEWIN::post(void) {
  return post_menu(M);
}

int EXEWIN::unpost(void) {
  return unpost_menu(M);
}

int EXEWIN::run(void) {
  int a,b;

  for (;;)
    {
      int c = wgetch(W);
      switch (c)
	{
	case KEY_UP:
	  if (item_index(current_item(M))==0)
	    menu_driver (M,REQ_LAST_ITEM);
	  else
	    menu_driver (M,REQ_PREV_ITEM);
	  break;

	case KEY_DOWN:
	  if (item_index(current_item(M))==item_count(M)-1)
	    menu_driver (M,REQ_FIRST_ITEM);
	  else
	    menu_driver (M,REQ_NEXT_ITEM);
	  break;

	case KEY_ENTER:
	case 0x0D: /* 13 - CR */
	case KEY_RIGHT:
	case ' ':
	    return REQ_SELECT;

	case KEY_A1:
	case KEY_HOME:
	  menu_driver (M,REQ_FIRST_ITEM);
	  break;

	case KEY_C1:
	case KEY_END:
	  menu_driver (M,REQ_LAST_ITEM);
	  break;

	case KEY_NPAGE:
	case KEY_C3:
	  menu_format (M,&a, &b);
	  b = item_index(current_item(M));
	  if ((a+b) < item_count(M))
	    for (b=0; b<a; b++)
	      menu_driver(M,REQ_NEXT_ITEM);
	  else
	    menu_driver (M,REQ_LAST_ITEM);	    
	  break;

	case KEY_PPAGE:
	case KEY_A3:
	  menu_format (M,&a, &b);
	  b = item_index(current_item(M));
	  if ((b-a) > 0)
	    for (b=0; b<a; b++)
	      menu_driver(M,REQ_PREV_ITEM);
	  else
	    menu_driver (M,REQ_FIRST_ITEM);
	  break;

	case 'q':
	case 'Q':
	case KEY_ESC:
	  return REQ_EXIT;

	default:
	  break;
	}
      father->paint();
    }
  return OK;
}

int EXEWIN::create(p_exe ptr_exe) {
  int i;
  int j = ptr_exe->num_cards();
  char *p1, *p2;
  
  I = new (ITEM*)[j+1];
  I[j] = NULL;
  
  for (i=0; i<j; i++, ptr_exe->next_card()) {
    p1 = ptr_exe->read_token(TKN_EXECUTABLE);
    p2 = ptr_exe->read_token(TKN_DESCRIPTION);
    I[i] = new_item(p1, p2);
  }

  M = new_menu(I);
  set_menu_win(M,W);
  set_menu_sub(M,W);
  set_menu_format(M,A.h,1);
  post_menu(M);
  menu_driver (M,REQ_FIRST_ITEM);

  return OK;
}

int EXEWIN::redraw(void) {
  return wnoutrefresh(W);
}

ATTRIBS *EXEWIN::attrib(void) {
  return (&A);
}


scr::scr (void) {
  (void) initscr();
  keypad(stdscr,TRUE);
  (void) nonl();
  (void) cbreak();
  (void) noecho();
  intrflush(stdscr,FALSE);

  if (has_colors())
    {
      start_color();

      init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
      init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
      init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
      init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
      init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
      init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
      init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
      init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);
    }
  
  stxwin = new STATUS(this);
  optwin = new OPTIONS(this);
  dirwin = new DIRWIN(this);
  exewin = new EXEWIN(this);

  dirwin->set_dir("./");

  draw_scr();
}

scr::~scr (void) {
  delete stxwin;
  delete optwin;
  delete dirwin;
  delete exewin;
  werase(allwin);
  wrefresh(allwin);
  delwin(allwin);
  endwin();
}



int scr::run (void) {
  int key=0;

  exewin->create(launch);
  stxwin->set_status("^,v-Move enter,>-Select q/esc-Quit");
  paint();
  
  while ((key=exewin->run())!=REQ_EXIT)
    if (key==REQ_SELECT)
      {
	launch->set_card(exewin->itemindex());
	strcpy(executable,launch->read_token(TKN_EXECUTABLE));
	dirwin->set_dir(launch->read_token(TKN_OBJECT));
	optwin->set_pattern(RE_SYNTAX_AWK);
	optwin->set_filter(launch->read_token(TKN_FILTER));
	optwin->set_options(launch->read_token(TKN_PARAMETERS));
	stxwin->set_status("^,v-Move enter,>-Select <,Esc-Back TAB-next field");
	dirwin->select_dir();
	paint();
	do {
	  key=dirwin->run();
	  switch (key) {
	  case REQ_SELECT:
	    exit(execute());
	    break;

	  case REQ_NEXT:
	    stxwin->set_status("enter,>-Select <,Esc-Back TAB-next field");
	    paint();
	    key = optwin->run();
	    switch (key) {
	    case REQ_SELECT:
              exit(execute());
	      break;

	    case REQ_NEXT:
	    case REQ_PREV:
	      stxwin->set_status("^,v-Move enter,>-Select <,Esc-Back TAB-next field");
	      paint();
	    }
	    break;
	  }
	} while (key!=REQ_EXIT);
	
      }

  return OK;
}

int scr::paint (void) {
  wnoutrefresh(allwin);
  dirwin->redraw();
  exewin->redraw();
  optwin->redraw();
  stxwin->redraw();
  doupdate();
  return OK;
}

int scr::draw_scr(void) {
  int curr_x, curr_y;
  int aux;

  getmaxyx (stdscr,curr_y,curr_x);

  allwin = subwin(stdscr,curr_y,curr_x,0,0);
  keypad(allwin,TRUE);
  leaveok (allwin,TRUE);

  for (aux=1; aux<curr_x-1; aux++)
    {
      mvwaddch(allwin,0,aux,ACS_HLINE);
      mvwaddch(allwin,curr_y-1,aux,ACS_HLINE);
    }
  for (aux=1; aux<curr_y-1; aux++)
    {
      mvwaddch(allwin,aux,0,ACS_VLINE);
      mvwaddch(allwin,aux,curr_x-1,ACS_VLINE);
    }
  mvwaddch(allwin,0,0,ACS_ULCORNER);
  mvwaddch(allwin,curr_y-1,0,ACS_LLCORNER);
  mvwaddch(allwin,0,curr_x-1,ACS_URCORNER);
  mvwaddch(allwin,curr_y-1,curr_x-1,ACS_LRCORNER);
  mvwaddstr(allwin,0,(curr_x/2)-(strlen(WEBBLE)/2),WEBBLE);

  make_border (dirwin->attrib());
  make_border (exewin->attrib());

  return OK;
}

void scr::make_border(ATTRIBS *A) {
  int aux;

  for (aux=A->x; aux<A->x+A->w; aux++)
    {
      mvwaddch(allwin,A->y-1,aux,ACS_HLINE);
      mvwaddch(allwin,A->y+A->h,aux,ACS_HLINE);
    }
  for (aux=A->y; aux<A->y+A->h; aux++)
    {
      mvwaddch(allwin,aux,A->x-1,ACS_VLINE);
      mvwaddch(allwin,aux,A->x+A->w,ACS_VLINE);
    }
  mvwaddch(allwin,A->y-1,A->x-1,ACS_ULCORNER);
  mvwaddch(allwin,A->y+A->h,A->x-1,ACS_LLCORNER);
  mvwaddch(allwin,A->y-1,A->x+A->w,ACS_URCORNER);
  mvwaddch(allwin,A->y+A->h,A->x+A->w,ACS_LRCORNER);

}

int scr::set_exe(p_exe pointer) {
  launch=pointer;
  return OK;
}


int scr::execute(void) {
  char target[100];
  char opt[100];
  int result;

  strcpy(opt, optwin->get_opt());

  strcpy(target, dirwin->get_dir());
  strcat(target,"/");
  strcat(target, dirwin->get_item());

  delete stxwin;
  delete optwin;
  delete dirwin;
  werase(allwin);
  wrefresh(allwin);
  delwin(allwin);
  endwin();

  cout << "running :\n";
  cout << executable << " " << opt << " " << target << "\n";
  result=execlp(executable,opt,target,NULL);
  switch (result) {
  case EACCES:
    cout << "(EACCES) - File is not a regular file\n";
    cout << "(EACCES) - Execute permission is denied for the file\n";
    break;
  case EPERM:
    cout << "(EPERM) - File system is mounted noexec\n";
    cout << "(EPERM) - File system is mounted nosuid and the file has and SUID or SGID bit set\n";
    break;
  case E2BIG:
    cout << "(E2BIG) - The argument list is too big\n";
    break;
  case EFAULT:
    cout << "(EFAULT) - Filename points outside your accessible address space\n";
    break;
  case ENOEXEC:
    cout << "(ENOEXEC) - The magic number in the file is incorrect\n";
    break;
  case ENAMETOOLONG:
    cout << "(ENAMETOOLONG) - Filename too long\n";
    break;
  case ENOENT:
    cout << "(ENOENT) - The file does not exist\n";
    break;
  case ENOMEM:
    cout << "(ENOMEM) - Insufficient kernel memory was available\n";
    break;
  case ENOTDIR:
    cout << "(ENOTDIR) - A component of the path prefix is not a directory\n";
    break;
  case ELOOP:
    cout << "(ELOOP) - Filename contains a circular reference\n";
    break;
  case ETXTBSY:
    cout << "(ETXTBSY) - Executable was open for writing by one or more processes\n";
  default:
    cout << "Unrecognized error code - AAAARRRRRGGHHHH!\n";
    break;
  }
 
  return 0;
}

int select_fil (const struct dirent *file) {
  return myscreen->dirwin->select (file);
}

void check_fld(FORM *Frm) {
  myscreen->optwin->check_field(Frm);
  return;
}
