;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.

(define-syntax define-open-flags
  (syntax-rules ()
    ((define-opens form ...)
     (begin (define-enum-constant "open" . form) ...))))

(define-open-flags
  ;; POSIX
  (read			0)
  (write		1)
  (read+write		2)
  (nonblocking		4)
  (append		#o10)
  (no-control-tty	#o20)
  (create		#o1000)
  (truncate		#o2000)
  (exclusive		#o4000)

  ;; NextStep
  (sync		#o1000000)	; Synchronous writes
  (async	#o100))		; Signal process group when data

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))

;;;; fcntl
;;;; Rough sketch only. Will define a separate proc for each fcntl command.
;
;;;; fcntl commands
;dup
;
;get-flags	; Only gives close-on-exec bit.
;set-flags
;
;get-status	; Returns open flags + get-status flags (below)
;set-status	; Can set: append, sync, async, nbio, nonblocking, no-delay
;
;get-lock
;set-lock
;nonblocking-set-lock
;
;get-record-lock
;set-record-lock
;set-record-lock-noblock
;
;get-owner			; Not POSIX
;set-owner			; Not POSIX
;remote-set-lock		; Not POSIX
;nonblocking-remote-set-lock	; Not POSIX
;remote-get-lock		; Not POSIX
;
;;;; Flags
;
;close-on-exec	; get-flags
;
;async		; get-status
;no-delay	; get-status
;nbio		; get-status
;
;;; These are internal; they are not part of the supported scsh interface.

(define fcntl/close-on-exec 		1)

(define fcntl/dupfd			0)
(define fcntl/get-fd-flags		1)
(define fcntl/set-fd-flags		2)
(define fcntl/get-file-flags		3)
(define fcntl/set-file-flags		4)
(define fcntl/get-owner			5)	; Not POSIX
(define fcntl/set-owner			6)	; Not POSIX
(define fcntl/get-record-lock		7)	; F_GETLK
(define fcntl/set-record-lock-noblock	8)	; F_SETLK
(define fcntl/set-record-lock		9)	; F_SETLKW

(define lock/read	1)	; F_RDLCK
(define lock/write	2)	; F_WRLCK
(define lock/release	3)	' F_UNLCK
