/* Exports from network1.c. */

int scheme_bind(int sockfd, int family, scheme_value scheme_name);

int scheme_connect(int sockfd, int family, scheme_value scheme_name);

int scheme_accept(int sockfd, int family, scheme_value scheme_name);

int scheme_peer_name(int sockfd, int family, scheme_value scheme_name);

int scheme_socket_name(int sockfd, int family, scheme_value scheme_name);

int scheme_socket_pair(int type, int *s1, int *s2);

int recv_substring(int s, int flags, scheme_value buf, 
		   int start, int end, scheme_value scheme_name);

int send_substring(int s, int flags, scheme_value buf, int start, int end,
		   int family, scheme_value scheme_name);

int scheme_getsockopt (int s, int level, int optname);

int scheme_getsockopt_linger (int s,
			      int level,
			      int optname,
			      int *out_time);

int scheme_getsockopt_timeout (int s,
			       int level,
			       int optname,
			       int *out_usec);

int scheme_setsockopt (int s,
		       int level,
		       int optname,
		       int optval);

int scheme_setsockopt_linger (int s,
			      int level,
			      int optname,
			      int onoff,
			      int linger);

int scheme_setsockopt_timeout (int s,
			       int level,
			       int optname,
			       int sec,
			       int usec);

int scheme_host_address2host_info(scheme_value scheme_name,
				  char** hostname,
				  char*** aliases,
				  char*** addresses);

int scheme_host_name2host_info(const char* scheme_name,
			       char**  hostname,
			       char*** aliases,
			       char*** addresses);

int scheme_net_address2net_info(scheme_value scheme_name,
				scheme_value scheme_net,
				char** netname,
				char*** aliases);

int scheme_net_name2net_info(const char* scheme_name,
			     scheme_value scheme_net,
			     char**  netname,
			     char*** aliases);


/* in_port should be declared u_short, but cig doesn't know about them. */

int scheme_serv_port2serv_info(int in_port,
			       const char* in_proto,
			       char**	   out_servname,
			       char***     out_aliases,
			       int*        out_port,
			       char**      out_protocol);

int scheme_serv_name2serv_info(const char* in_name,
			       const char* in_proto,
			       char**   out_servname,
			       char***  out_aliases,
			       int*     out_port,
			       char**   out_protocol);

int scheme_proto_num2proto_info(int     in_proto,
				char**  out_protoname,
				char*** out_aliases,
				int*    out_protocol);

int scheme_proto_name2proto_info(const char*   in_name,
				 char**  out_protoname,
				 char*** out_aliases,
				 int*    out_protocol);

void set_longvec_carriers(scheme_value svec, long const * const * cvec);

scheme_value veclen(const long *vec);
