/* This is an Scheme48/C interface file, 
** automatically generated by cig.
*/

#include <stdio.h>
#include <stdlib.h> /* For malloc. */
#include "libcig.h"

#include <ndbm.h>

extern int errno;

#define errno_or_false(x) (((x) == -1) ? ENTER_FIXNUM(errno) : SCHFALSE)

/* stub used to return FALSE when scheme checks for Berkeley dbm */
int db_check()
  return 1;

scheme_value df_database_open(long nargs, scheme_value *args)
{
    extern int database_open(const char *, int , int , DBM** *);
    scheme_value ret1;
    int r1;
    DBM** r2;

    cig_check_nargs(4, nargs, "database_open");
    r1 = database_open(cig_string_body(args[3]), EXTRACT_FIXNUM(args[2]), EXTRACT_FIXNUM(args[1]), &r2);
    ret1 = errno_or_false(r1);
    AlienVal(VECTOR_REF(*args,0)) = (long) r2;
    return ret1;
    }

scheme_value df_database_close(long nargs, scheme_value *args)
{
    extern int database_close(DBM* );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "database_close");
    r1 = database_close((DBM* )AlienVal(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_database_error(long nargs, scheme_value *args)
{
    extern int database_error(DBM* );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "database_error");
    r1 = database_error((DBM* )AlienVal(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_database_clearerr(long nargs, scheme_value *args)
{
    extern int database_clearerr(DBM* );
    scheme_value ret1;
    int r1;

    cig_check_nargs(1, nargs, "database_clearerr");
    r1 = database_clearerr((DBM* )AlienVal(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_database_delete(long nargs, scheme_value *args)
{
    extern int database_delete(DBM* , const char *);
    scheme_value ret1;
    int r1;

    cig_check_nargs(2, nargs, "database_delete");
    r1 = database_delete((DBM* )AlienVal(args[1]), cig_string_body(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_database_fetch(long nargs, scheme_value *args)
{
    extern const char *database_fetch(DBM* , const char *);
    scheme_value ret1;
    const char *r1;

    cig_check_nargs(3, nargs, "database_fetch");
    r1 = database_fetch((DBM* )AlienVal(args[2]), cig_string_body(args[1]));
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

scheme_value df_database_store(long nargs, scheme_value *args)
{
    extern int database_store(DBM* , const char *, const char *, int );
    scheme_value ret1;
    int r1;

    cig_check_nargs(4, nargs, "database_store");
    r1 = database_store((DBM* )AlienVal(args[3]), cig_string_body(args[2]), cig_string_body(args[1]), EXTRACT_FIXNUM(args[0]));
    ret1 = ENTER_FIXNUM(r1);
    return ret1;
    }

scheme_value df_database_first(long nargs, scheme_value *args)
{
    extern const char *database_first(DBM* );
    scheme_value ret1;
    const char *r1;

    cig_check_nargs(2, nargs, "database_first");
    r1 = database_first((DBM* )AlienVal(args[1]));
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

scheme_value df_database_next(long nargs, scheme_value *args)
{
    extern const char *database_next(DBM* );
    scheme_value ret1;
    const char *r1;

    cig_check_nargs(2, nargs, "database_next");
    r1 = database_next((DBM* )AlienVal(args[1]));
    ret1 = VECTOR_REF(*args,0);
    {AlienVal(CAR(ret1)) = (long) r1; CDR(ret1) = strlen_or_false(r1);}
    return ret1;
    }

