#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include "cstuff.h"

extern int errno;

/* Hack the blocked-signal mask.
*******************************************************************************
*/


#include "machine/sigset.h"

int set_procmask(int hi, int lo, int *old_lo_p)
{
    sigset_t mask, old_mask;
    int old_hi;

    make_sigset(&mask, hi, lo);
    
    sigprocmask(SIG_SETMASK, &mask, &old_mask);
    split_sigset(old_mask, &old_hi, old_lo_p);
    return old_hi;
    }


int get_procmask(int *old_lo_p)
{
    sigset_t old_mask;
    int old_hi;

    sigprocmask(SIG_SETMASK, NULL, &old_mask);
    split_sigset(old_mask, &old_hi, old_lo_p);
    return old_hi;
    }


/* Set/Get signal handlers
*******************************************************************************
*/

long int pending_signals = 0;
void scm_handle_sig(int sig) {pending_signals |= (1<<sig);}


scheme_value set_int_handler(int sig, scheme_value handler, int flags,
			     scheme_value *ohandler, int *oflags)
{
    struct sigaction new, old;

    sigemptyset(&new.sa_mask); /* WTF */
    new.sa_flags = flags;

    if( handler == SCHFALSE ) new.sa_handler = SIG_IGN;
    else if( handler == SCHTRUE ) new.sa_handler = SIG_DFL;
    else {
	new.sa_handler = scm_handle_sig;
	/* Do other stuff. */
	}

    if( sigaction(sig, &new, &old) ) {
	*ohandler = SCHFALSE;
	return ENTER_FIXNUM(errno);
	}

    *oflags = old.sa_flags;
    if( old.sa_handler == SIG_IGN ) *ohandler = SCHFALSE;
    else if( old.sa_handler == SIG_DFL ) *ohandler = SCHTRUE;
    else if( old.sa_handler == scm_handle_sig ) {
	*ohandler = ENTER_FIXNUM(0); /* Fix later. */
	}
    else *ohandler = ENTER_FIXNUM(-1); /* Unknown signal handler. */
    return SCHFALSE;
    }


scheme_value get_int_handler(int signal, scheme_value *handler, int *flags)
{
    struct sigaction old;

    if( sigaction(signal, NULL, &old) ) {
	*handler = SCHFALSE;
	return ENTER_FIXNUM(errno);
	}
	
    *flags = old.sa_flags;
    if( old.sa_handler == SIG_IGN ) *handler = SCHFALSE;
    else if( old.sa_handler == SIG_DFL ) *handler = SCHTRUE;
    else if( old.sa_handler == scm_handle_sig ) {
	*handler = ENTER_FIXNUM(0); /* Fix later. */
	}
    else *handler = ENTER_FIXNUM(-1); /* Unknown signal handler. */
    return SCHFALSE;
    }
