;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.

(define-syntax define-open-flags
  (syntax-rules ()
    ((define-errnos form ...)
     (begin (define-enum-constant "open" . form) ...))))

(define-open-flags
  (read			0)
  (write		1)
  (read+write		2)
  (append		8)
  (create		#x100)
  (exclusive		#x400)
  (no-control-tty	#x800)
  (nonblocking		#x80)
  (truncate		#x200)

;;; Not POSIX.
  (no-delay	4)
  (sync		#x10))

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))

(define fcntl/close-on-exec 		1)
(define fcntl/dupfd			0)
(define fcntl/get-fd-flags		1)
(define fcntl/set-fd-flags		2)
(define fcntl/get-file-flags		3)
(define fcntl/set-file-flags		4)
(define fcntl/get-record-lock		5)
(define fcntl/set-record-lock-noblock	6)
(define fcntl/set-record-lock		7)

(define lock/read	1)
(define lock/write	2)
(define lock/release	3)
