/****************************************************************/
/*	Menubld 2.0 Menu System     			        */ 
/*	Create By Champ Clark III				*/
/*	Version 2.0						*/
/*								*/
/*	Version 1:  Basicly layout created			*/
/*	Version 1.2: Created new menu layout, motd support	*/
/*	Version 1.5: Small bug fixes,  and enhanced layout	*/
/*	Version 2.0: More small bug fixes.  Released this thang */
/****************************************************************/

#include <stdio.h> 
#include <unistd.h>
#include <string.h> 
#include <curses.h>

/* Where the default directory for the menu.cfg flat ASCII files 
   are stored.  You may wish to change this */

#define DEFAULTMENU "/usr/local/lib/menubld/main.cfg"

FILE *fp;
char inbuf[1024];
char *in[1024]; 
char sp[]="|";				/* Separator in flatfile */
char infile[80];
char oldinfile[80];

int c, i, j, k, l, x, g;

struct menu_cfg				/* Create a char. array so we can */
	{				/* store all menucfg information  */
	char cmd_type[10];		/* Another Menu, or a actual command */
	char fld[60];			/* First Field */
	char fld_desc[80];		/* Tells the user what this option is */
	} menucfg[20];

/************************************************************************/
/*  getscreen() draws the initial screen based on the information	*/
/*  stored in the menu_cfg array.					*/
/************************************************************************/

void getscreen(void)
{
initscr();
refresh();
noecho();
nonl();
cbreak();
keypad(stdscr,  TRUE);

meta(stdscr, TRUE);
attron(A_BOLD);
k = 3;

for (i = 0; i < j; i++)
{
	move(k,4);
	printw("%s\n",  menucfg[i].fld_desc);
	k++;
}
attroff(A_BOLD);
attron(A_REVERSE);
move(1,0);
printw("   MenuBuild [V2.0]                                                            ");
for (i = 1; i < 23; i++)
{
	move(i, 55);
	printw(" ");
}

attroff(A_REVERSE);

        attron(A_BOLD);

	move(3, 57);
	printw("Menubld [2.0]");
	move(4,57); 
        printw("By Champ Clark III");
	move(5,57);
	printw("champ@vistech.net");
	attroff(A_BOLD);


	move(8, 57);
	printw("Hit 'h' for help");
	move(9, 57);
	printw("");
	move(10,57);
	printw("Hit 'q' to quit");
	move(12,57);

attron(A_NORMAL);
move(22,0);
attron(A_REVERSE);
printw("                                                                                ");
attroff(A_REVERSE);
attroff(A_NORMAL);
}


/***********************************************************************/
/* getflat() actually opens the menu flat and stores its contents into */
/* the menu_cfg array						       */
/***********************************************************************/

void getflat(void)
{
if ((fp = fopen(infile, "r")) == NULL)
	{
	fprintf(stderr, "Error: %s file not found!\n", infile);
	exit(1);
	}

/*
   Actually grab the configuration information and store it into 
   our array. 
*/

j=0;
while (fgets(inbuf,1024,fp) != NULL)
	{
	
	/* discard comments */
	if(inbuf[0] == '#') continue;
	
	sprintf(menucfg[j].cmd_type, "%s", strtok(inbuf, sp));
	sprintf(menucfg[j].fld, "%s", strtok(NULL, sp));
	sprintf(menucfg[j].fld_desc, "%s", strtok(NULL, sp));

	++j;
	}
}

int main(int argc, char **argv)
{

if ( argc < 2 )
	{	
	sprintf(infile, "%s", DEFAULTMENU);	
	} else {
	sprintf(infile, "%s", argv[1]);  }

sprintf(oldinfile, "%s", infile);    /* So things don't crap out */

getflat();		/* Call To Get Flat File */

getscreen();		/* Draw the option screen */
x=3;			/* Variable holds arrow postion */
l=0;			/* Hold our variable counter */

move(x,0);
printw("=->");		/* Draw the initial arror */

while (1)
{
	c=getch();
	move(x,0);
	printw("    ");		/* Erase old arror */
	switch(c)		/* Get the key entered */
	{
	
	case	'k':
	case	KEY_UP:
		if ( x > 3 )
		{
			x--;
			l--;
		} else
		{ 
			x = k-1; 
			l = x-3;
		}	
		break;


	case 	'j':
	case	KEY_DOWN:
		if ( x < k-1 )
		{
			x++;
			l++;
		} else
		{
			x = 3;
			l = 0;
		}
		break;

	case	'q':
		clear();
		endwin();
		exit();
		break;

	case	'b':
	case	KEY_LEFT:
		sprintf(infile, "%s", oldinfile);
	        clear();
	        endwin();
		x = 3;
		l = 0;
	        getflat();
	        getscreen();
		break;

	case	'h':
	case	'?':
		clear();
		endwin(); 
		initscr();
		refresh();
		noecho();
		nonl();
		cbreak();
		
		attron(A_REVERSE);
		move(1,1); 
		printw("               MenuBuild [2.0] System Keyboard Help Screen                     ");
		attroff(A_REVERSE);	

		move(4,17);
		printw("UP ARROW or 'k' = Moves selector UP"); 
		move(6,17); 
		printw("DOWN ARROW or 'j' = Moves selector DOWN");
		move(8,17);
		printw("ENTER/LEFT ARROR = Selects a item");
		move(10,17);
		printw("RIGHT ARROW or 'b' = Backs up one screen");
		move(12,17);
		printw("'?' or 'h' = Prints this screen");
		attron(A_REVERSE);
		move(23,30);
		printw("   Press Any Key  ");
		attroff(A_REVERSE);

		g=getch();
		clear();
		endwin();
		getscreen();
		break;



	default:
		clear();
		endwin();

/* Only two types of config files commands are used right now.  
   MNU types (goes to another menu) or CMD type (executes a 
   command */

		if (strcmp(menucfg[l].cmd_type, "CMD") == 0)
                { system(menucfg[l].fld); }
                
		
		if (strcmp(menucfg[l].cmd_type, "MNU") == 0)
			{
			sprintf(oldinfile, "%s", infile);
			sprintf(infile, "%s", menucfg[l].fld);
			getflat();
			x=3;
			l=0;
			}

		getscreen();
		break;
		
	
	}

move(x, 0);
printw("=->");
}
} 


