
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <stdio.h>

#include "menu.h"
#include "misc.h"
#include "node.h"

MENU *current_menu;

int
search_menu( target )
char *target;
{
	MENU *menu = current_menu;
	int i;
	char *ptr;
	char lo_menu[MAX_TITLE_LEN+1];
	char lo_target[MAX_TITLE_LEN+1];
	int lno;

	strcpy( lo_target, target );
	locase( lo_target );
	/* search the menu lines */
	for( i = 0; i < MAX_MENU_ENTRIES && i < menu->mn_nrows; i++ ) {
		lno = (cur_line_no + i + 1) % menu->mn_nrows;
		strcpy( lo_menu, menu->mn_line[lno] );
		locase( lo_menu );
		if( strstr( lo_menu, lo_target ) ) return( lno );
	}
	return( -1 );
}

locase( string )
char *string;
{
	for( ; *string != '\0'; string++ ) {
		if( isupper(*string) ) *string = *string - ('A' - 'a');
	}
}
