
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include "misc.h"

#include <pwd.h>
#include <string.h>
#include <stdio.h>

char user_logon[9];
char user_home[30];
char base_dir[100];

/*	set up path, set up environment variables */

init_env()
{
	struct passwd *pw, *getpwuid();
	char lib_path[200];
	char *ptr, *getenv();
	char *env_ptr, *getenv();
	char temp[100];

	/* ---- PATH & MENU_LIB ----  */ 

	env_ptr = getenv( "MENU_DIR" );
	if( env_ptr != NULL ) {
		strcpy( base_dir, env_ptr );
	} else {
		strcpy( base_dir, MENU_DIR );
	}

	strcpy( lib_path, base_dir );
	strcat( lib_path, "/lib" );
	setenv( "MENU_LIB", lib_path, 1 );

	/* add menu lib directory to path */
	set_path( lib_path );


	/* ---- USER, NAME, and user_home ---- */
	/* find out and save basic info. about user */

	pw = getpwuid( geteuid() );
	if( pw == NULL ) {
		fatal("*** can't get user info");
	}
	strcpy( user_logon, pw->pw_name );
	strcpy( user_home, pw->pw_dir );

	setenv( "USER", user_logon, 1 );

	if( getenv( "NAME" ) == NULL ) {
		/* get name, ignore blanks, use "no name" if nothing left */
		strcpy( temp, pw->pw_gecos );
		strtok( temp, "," );
		ptr = temp;
		while( isspace( *ptr ) ) ptr++;
		if( *ptr == '\0' ) ptr = "no name";
		setenv( "NAME", ptr, 1 );
	}


	/* ---- EDITOR ---- default is pico */

	if( getenv( "EDITOR" ) != NULL ) {
		/* no action needed */
	} else if( (ptr = getenv( "VISUAL" )) != NULL ) {
		setenv( "EDITOR", ptr, 1 );
	} else {
		setenv( "EDITOR", "pico", 1 );
	}


	/* ---- NEWS_READER ---- default is tin */ 

	if( getenv( "NEWS_READER" ) == NULL ) {
		setenv( "NEWS_READER", "tin", 1 );
	}

	/* ---- PAGER ---- default is more -d */ 

	if( getenv( "PAGER" ) == NULL ) {
		setenv( "PAGER", "more -d", 1 );
	}
}

/* set PATH in the environment */

set_path( lib_path )
char *lib_path;
{
	char *getenv();
	char *old_path;
	char new_path[500];

	old_path = getenv( "PATH" );
	strcpy( new_path, lib_path );
	strcat( new_path, ":" );
	strcat( new_path, old_path );
	setenv( "PATH", new_path, 1 );
}

set_last_env()
{
	FILE *stream;
	char line[100];
	char buf[100];
	char fname[100];

	/* find last line in .cshrc, should be setenv;
			do setenv() to save the value */

	strcpy( fname, user_home );
	strcat( fname, "/.cshrc" );
	stream = fopen( fname, "r" );
	if( stream == NULL ) return;

	while( fgets( buf, 90, stream ) != NULL ) {
		strcpy( line, buf );
	}
	fclose( stream );
	*(strchr(line,'\n')) = '\0';
	
	execute_last_env( line );
}

execute_last_env( line )
char *line;
{
	char *ptr, *ptr1;
	char *value;
	char *var_name;

	/* scanning line of form:
	 *
	 *	setenv PAGER 'more -d'
	 *
	 */

	/* skip initial white space */
	ptr = line;
	while( isspace(*ptr) ) ptr++;

	/* check for "setenv" */
	if( strncmp( ptr, "setenv", 6 ) != 0 ) return;
	ptr += 6;

	/* skip white space up to environment variable name */ 
	while( isspace(*ptr) ) ptr++;
	if( *ptr == '\0' ) return;

	/* scan env. variable name */
	var_name = ptr;
	while( ! isspace(*ptr) && *ptr != '\0' ) ptr++;
	if( *ptr == '\0' ) return;
	/* delimit it */
	*ptr = '\0';
	ptr++;

	/* skip white space */
	while( isspace(*ptr) ) ptr++;
	if( *ptr == '\n' ) return;

	/* now get new value */
	value = ptr;
	ptr = value + strlen(value);
	while( isspace( *(ptr - 1) ) ) ptr--;
	*ptr = '\0';

	/* get rid of delimiters ' or " if present */
	ptr--;
	if( ( ptr > value ) && ( *value == '\'' && *ptr == *value )
			||     ( *value == '"' && *ptr == *value ) ) {
		value++;
		*ptr = '\0';
	}

	setenv( var_name, value, 1 );
}
