#
#	this filter cleans up the menu2.0 logs
#
#	it deletes fragments of menu sessions, created by simultaneous
#		writes or file system full
#	it merges segments into full session records where a menu
#		session included so many commands that several
#		writes of log records took place
#
$state = 0;
LOOP:
while( <> ) {

	#
	#	first basic tests that input line is ok
	#

	if( length( $_ ) < 4 ) {
		&error( "*** input line to short" );
		next LOOP;
	}

	# log lines start  "xk:" where "x" is the last character of
	# login and "k" is the key to the type of log entry.
	/^(.)(.)(.)(.*)$/;
	if( $3 ne ":" ) {
		&error( "Input record has no colon" );
		next LOOP;
	}
	$first = $1;
	$key = $2;
	$rest = $4;

	if( $state != 0 && $state != 99 ) {
		if( $let1 ne $first ) {
			&error("initial letter mismatch: $let1 != $first");
			$state = 99;
			next LOOP;
		}
	}

	#
	#	Now do whatever for the various states
	#

	if( $state == 99 ) {
		# error recovery mode - want ">:" to restart
		if( $key eq ">" ) {
			&do_gtr;
		} else {
			# skip
		}
	} elsif( $state == 0 ) {
		# nothing saved so far
		# looking for ">:" to start new series
		if( $key eq ">" ) {
			&do_gtr;
		} else {
			&error( "missing >: line" );
		}
	} elsif( $state == 1 ) {
		# previous line was ">:"
		# now "B:begin" for initial and state -> 2
		# all else is continuation, state -> 4
		$count++;
		$current .= $_;
		if( $key eq "B" ) {
			$begin = 1;
			$state = 2;
		} elsif ( $key eq ">" ) {
			&error( "two consecutive > lines" );
		} elsif ( $key eq "<" ) {
			&error( "null session" );
		} else {
			$begin = 0;
			$state = 4;
		}
	} elsif( $state == 2 ) {
		# have ">:" and "B:", so in the middle of initial segment
		if( $key eq "E" ) {
			$state = 3;
			$current .= $_;
			/^(.*)\/(.*)$/;
			$E_count = $2;
			$diff = $2 - $E_count;
			if( $count != $E_count ) {
				&error( "count=$count, E: count = $E_count" );
			}
		} elsif( $key eq "<" ) {
			$current .= $_;
			$save_segment{$identifier} .= $current;
			$state = 0;
			$current = "";
		} else {
			$count++;
			$current .= $_;
		}
	} elsif( $state == 3 ) {
		# have seen ">:", "B:", "E:", want "<:"
		if( $key eq "<" ) {
			$state = 0;
			undef @want;
			$current .= $_;
			print $current;
			$current = "";
		} else {
			&error( "missing <:" );
		}
	} elsif( $state == 4 ) {
		# saw ">", no "B" following, in middle of continuation segment
		if( $key eq "E" ) {
			$state = 5;
			$current .= $_;
			$count++;
		} elsif( $key eq "<" ) {
			$current .= $_;
			$save_segment{$identifier} .= $current;
			$state = 0;
			$current = "";
		} else {
			$count++;
			$current .= $_;
		}
	} elsif( $state == 5 ) {
		# saw ">", no "B", then "E"; need "<"
		if( $key eq "<" ) {
			$current .= $_;
			$save_segment{$identifier} .= $current;
			$state = 0;
			$current = "";
		} else {
			&error( "missign <:" );
		}
	}
}

#	Now process segmented sessions

SEGLOOP:
foreach $i ( keys %save_segment ) {
	undef @want;
	@lines = split( "\n", $save_segment{$i} );
	$n = @lines;
	$indB = 1;
	$indE = @lines-2;
	$lineE = $lines[$indE];
	if( (substr( $lines[$indB], 1, 2 ) ne "B:") ||
			(substr( $lineE, 1, 2 ) ne "E:") ) {
		print STDERR "\tsaved begin line is $lines[$indB]\n";
		print STDERR "\tsaved next to last line is $lines[$indE]\n";
		print STDERR "*** error in segment, skipping $n lines ...\n";
		next SEGLOOP;
	}
	$keep = 0;
	$want[$keep++] = "$lines[0]";	# ">:"
	$want[$keep++] = "$lines[1]";	# "B:"
	for( $j = 2; $j < $indE; $j++ ) {
		$key = substr( $lines[$j], 1, 1 );
		if( $key eq "E" || $key eq "B" ) {
			print STDERR "line is $lines[$j]\n";
			print STDERR "error in segment, skipping $n lines ...\n";
			next SEGLOOP;
		}
		next if $key eq ">" || $key eq "<";
		$want[ $keep++ ] = $lines[$j];
	}
	$let1 = substr($lines[0],0,1);
	$number = sprintf("%05d", $keep-1);
	$want[ $keep++ ] = $let1 . "E:" . substr($lineE,3,6) . "/" . $number;
	$want[ $keep++ ] = "$let1<:";

	print join( "\n", @want );
	print "\n";
}

sub do_gtr {
	$state = 1;
	$identifier = $rest;
	$identifier =~ /^\w*(\w)/;
	$let1 = $1;
	$current = $_;
	$count = 0;
}

sub error {
	local( $reason ) = @_;

	print STDERR "*** error on line $. - $reason, skipping ...\n";
	$current = "";
	$state = 99;
}
