/*************************************************************************
** interpcom-3.1   (command interpreter)                                 **
** main.c : test program for the command interpreter                     **
**          Minimal application with external initialization file        **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"


FUNCTION           *Funcs;
FUNCTIONC          *Funcs_C;
int                 messg_cmd(FILE *, char *, flow_data *);


pfi                *proc[]={
    NULL,
};

FUNCTIONGen        *Funcs_Gen[] = {
    NULL,
};

pfib                procb_user[] = {
    messg_cmd,
    NULL,
};

char               *namesb_user[] = {
    "messg",
    "",
};

int
main(int argc, char *argv[])
{
    Funcs = Funcs_interp;
    Funcs_C = Funcs_interp_C;
    _NBFONC = _NBFONC0;
    _NBFONC_C = _NBFONC0_C;
    User_Init_File = NULL;
    prog_c(argc, argv, "interp.ini", NULL, 0, NULL, 0);
    return 0;
}

void
init_prog(flow_data *flow_interp)
{
}

void
init_thread_param(flow_data *flow_interp)
{
}

void init_expr_GEN(flow_data *flow_interp)
{
}

void
clean_thread_param(flow_data *flow_interp)
{
}

void
exit_prog()
{
    exit(0);
}

void
dest_prop(int typ, int i0, flow_data *flow_interp)
{
}


/*------------------------------------------------------------------*/
int                 nb_message_interp  = 174,
                    nb_message_interp0 = 66,
                    nb_message_interp1 = 146,
                    nb_message_interp2 = 154,
                    nb_message_interp3 = 156,
                    nb_message_interp4 = 158,
                    nb_message_interp5 = 162,
                    nb_message_interp6 = 164,
                    nb_message_interp7 = 166;
extern char        *_TIME_messg[],
                   *_MEMMC_messg[],
                   *_INTCOM_colors[],
                   *_PROGREPL_messg[],
                   *_INITERR_messg[],
                   *_DELPROG_messg[],
                   *names_interp[];
/*--------------------------------------------------------------------
    Function associated to the section '!help' of an initialization
    file
--------------------------------------------------------------------*/
int
messg_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             i0,
                    i;
    char            h_ligne[100];
    char            h[400];

    memset(h_ligne, 0, 100);

    while (fgets_count(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
            return 0;
        if (h_ligne[0] != ';') {
            nettoie(h_ligne);
            i0 = convert_int(h_ligne, flow_interp);
            if (i0 < 0 || i0 > nb_message_interp)
                exit_interp("intern");
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("intern");
            nettoie(h_ligne);
            if (i0 <= nb_message_interp0) {
                mess_interp[i0] = ch_copy(h_ligne);
            }
            else {
                if (i0 <= nb_message_interp1) {
                    for (i = 0; i <= nb_commandes; i++) {
                        if (comp(names[i],
                            names_interp[i0 - 1 - nb_message_interp0]) == 1) {
                            free(names[i]);
                            names[i] = ch_copy(h_ligne);
                            break;
                        }
                    }

                    names_interp[i0 - 1 - nb_message_interp0] =
                        ch_copy(h_ligne);
                    ch_prem();
                }
                else {
                    if (i0 <= nb_message_interp2) {
                        _EXPREV_errmessg[i0 - 1 - nb_message_interp1] =
                            ch_copy(h_ligne);
                    }
                    else {
                        if (i0 <= nb_message_interp3) {
                            _TIME_messg[i0 - 1 - nb_message_interp2] =
                                ch_copy(h_ligne);
                        }
                        else {
                            if (i0 <= nb_message_interp4) {
                                _PROGREPL_messg[i0 - 1 - nb_message_interp3] =
                                    ch_copy(h_ligne);
                            }
                            else {
                                if (i0 <= nb_message_interp5) {
                                    _INITERR_messg[i0 - 1 - nb_message_interp4]
                                        = ch_copy(h_ligne);
                                }
                                else {
                                    if (i0 <= nb_message_interp6) {
                                        _DELPROG_messg[i0 - 1 -
                                            nb_message_interp5] =
                                                ch_copy(h_ligne);
                                    }
                                    else {
                                        if (i0 <= nb_message_interp7) {
                                            _MEMMC_messg[i0 - 1 -
                                                nb_message_interp6] =
                                                    ch_copy(h_ligne);
                                        }
                                        else {
                                            _INTCOM_colors[i0 - 1 -
                                                nb_message_interp7] =
                                                    ch_copy(h_ligne);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            memset(h, 0, 400);
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/












