/*************************************************************************
** interpcom-3.1   (command interpreter)                                 **
** main.c : test program for the command interpreter                     **
**          Minimal application with external initialization file        **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"
#include <gmp.h>

mpq_t               GMP_Zero,
                    GMP_one;
mpz_t               GMP_Zero_int,
                    GMP_one_int;

FUNCTION           *Funcs;
FUNCTIONC          *Funcs_C;
extern  FUNCTIONGen Funcs_GMP[];

pfi                *proc[]={
    NULL,
};

FUNCTIONGen        *Funcs_Gen[] = {
    Funcs_GMP,
};

pfib                procb_user[] = {
    NULL,
};

char               *namesb_user[] = {
    "",
};

extern EXPREVAL_GEN _GMP_exprev;
extern int          _GMP_NBFONC0;


int
main(int argc, char *argv[])
{
    Funcs = Funcs_interp;
    Funcs_C = Funcs_interp_C;
    _NBFONC = _NBFONC0;
    _NBFONC_C = _NBFONC0_C;
    User_Init_File = NULL;
    prog_c(argc, argv, "interp.ini", NULL, 0, NULL, 0);
    return 0;
}

void
init_prog(flow_data *flow_interp)
{
}

void
init_thread_param(flow_data *flow_interp)
{
}

void init_expr_GEN(flow_data *flow_interp)
{
    NB_expr_eval = 3;
    _NBFONC_Gen[0] = _GMP_NBFONC0;
    Expreval_ops[0] = _GMP_exprev;
    mpq_init(GMP_Zero);
    mpq_init(GMP_one);
    mpz_init(GMP_Zero_int);
    mpz_init(GMP_one_int);
    mpz_set_si(GMP_one_int, 1);
    mpq_set_num(GMP_one, GMP_one_int);
}

void
clean_thread_param(flow_data *flow_interp)
{
}



void
exit_prog()
{
    exit(0);
}

void
dest_prop(int typ, int i0, flow_data *flow_interp)
{
}

