/*************************************************************************
** interpcom-3.1   (command interpreter)                                 **
** convert.c : conversion of a text file in a source file                **
**             (auxiliary program)                                       **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include <stdio.h>
#include "interp.h"
void            _perms(char *, char *);

int
main(int argc, char *argv[])
{
    FILE           *inpx,
                   *outx;
    char           *name_array,
                   *name_number,
                    direct[256],
                    inverse[256],
                    c;
    int             icmpt,
                    i,
                    nb;

    if (argc < 5) {
        printf("Usage : interp-convert <infile> <outfile> <name_str> <name_int>\n");
        return 1;
    }
    name_array = argv[3];
    name_number = argv[4];
    __perms(direct, inverse);

    inpx = fopen(argv[1], "rb");
    if (inpx == NULL) {
        printf("Input file could not be open\n");
        return 1;
    }
    outx = fopen(argv[2], "wb");
    if (outx == NULL) {
        printf("Output file could not be open\n");
        return 1;
    }
    fprintf(outx, "char %s[] = {\n", name_array);
    icmpt = 0;
    nb = 0;

    while (fread(&c, 1, 1, inpx) != 0) {
        icmpt++;
        nb++;
        if (nb > 1)
            fprintf(outx, "%s", ", ");
        if (icmpt == 13) {
            icmpt = 0;
            fprintf(outx, "\n");
        }
        i = (int) c;
        if (i < 0)
            i += 256;
        fprintf(outx, "%d", direct[i]);
    }

    fclose(inpx);
    fprintf(outx, "\n");
    fprintf(outx, "};\n");
    fprintf(outx, "\n");
    fprintf(outx, "int %s = %d;\n", name_number, nb);
    fclose(outx);
    return 0;
}

char
__chx(int i)
{
    if (i <= 128)
        return (char) i;
    else
        return (char)(i - 256);
}

void
__perms(char *direct, char *inverse)
{
    int             i,
                    j,
                    j0,
                    n,
                    x[256],
                    e[256];

    for (i = 0; i < 255; i++) {
        x[i] = (i * _P_MULT) % _PRIME_C;
        e[i] = 0;
    }

    for (i = 0; i < 255; i++) {
        n = -1;

        for (j = 0; j < 255; j++) {
            if (e[j] == 0) {
                if (x[j] > n) {
                     j0 = j;
                     n = x[j];
                }
            }
        }

        e[j0] = 1;
        direct[i] = __chx(j0);
        inverse[j0] = __chx(i);
    }
}
