/********************************************************************\
|* main.c -- Main Program for the INSANITY Shell Config Program     *|
|* (c) 1997 Project INSANITY Software.  By Steve Conley.  Do not    *|
|* modify or copy!                                                  *|
\********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fileio.h"

extern void edit(char* file);
extern char* DEF_FILE;
extern char* getuserpath(int uid);
char* VERSION="V5.0";

int main(int argc,char* argv[]){
	FILE* tmp;
	char* path=getuserpath(getuid());
	if(argc==1){
/* Check to see if the default file exists then exit, or if it doesn't
 * exist, enter the editor.
 */
		printf("INSANITY Init-time Configuration by Steve Conley (c)1997\n\r");
		strcat(path,DEF_FILE);
		tmp=fopen(path,"r");
		if(!tmp){
			edit(path);
			printf("If you want to edit your configuration later, type:\n\r");
			printf("%s %s\n\r",argv[0],DEF_FILE);
		}
		return(0);
	}
/* Otherwise, let's see what file where're supposed to edit. */
	if(!strncmp("-",argv[1],1)){
		printf("Project INSANITY Shell Configuration Program %s\n\r",VERSION);
		printf("Usage: %s [filename--optional]\n\r",argv[0]);
		return(0);
	}
	edit(argv[1]);
	return(0);
}
