#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fileio.h"

extern char* autoinsert;

char* HEADER=
"# C-Shell Configuration Generated by the INSANITY Program\n\r"
"# (c) 1997 Project INSANITY Software, by Steve Conley.\n\r"
"#########################################################\n\r\n\r";

void save(struct line* lines,char* filename){
	FILE* outfile;
	struct line* curline;
	outfile=fopen(filename,"w");
	if(outfile==NULL){
		printf("Hmm, I could not open the configuration file for read/write.\n\r");
		exit(2);
	}
	curline=lines;
	fwrite(HEADER,sizeof(char),strlen(HEADER),outfile);
	fwrite(autoinsert,sizeof(char),strlen(autoinsert),outfile);
	while(curline!=NULL){
		fwrite(curline->ln,sizeof(char),strlen(curline->ln),outfile);
		fwrite("\n",sizeof(char),1,outfile);
		curline=curline->next;
	}
	fclose(outfile);
}

void readin(char* filename,struct line* readto){
	FILE* infile;
	char* buf=(char*)malloc(sizeof(char));
	char* ln=(char*)malloc(sizeof(char)*1000);
	int len=0;
	infile=fopen(filename,"r");
	if(infile==NULL){
		printf("Hmm, I could not open the configuration file for reading.\n\r");
	}
	while(!feof(infile)){
		len=0;
		ln[0]='\0';
		fread(buf,sizeof(char),1,infile);
		while((*buf!='\n')&&(!feof(infile))){
			if((*buf=='#')&&(len==0)){
				while((*buf!='\n')&&(!feof(infile)))
					fread(buf,sizeof(char),1,infile);
			}		
			if((*buf!='\n')&&(*buf!='\r')){
					ln[len]=*buf;
					len++;
			}
			fread(buf,sizeof(char),1,infile);
		}
		if(ln[0]!='\0'){
			ln[len]='\0';
			addln(readto,ln);
		}
	}	
}

void addln(struct line* lines,char* toadd){
	struct line* morelns=lines;
	if(morelns==NULL){
		lines=(struct line*)malloc(sizeof(struct line));
		lines->next=NULL;
	}else{
		if(morelns->ln!=NULL){
			while(morelns->next!=NULL){
				morelns=morelns->next;
			}
			morelns->next=(struct line*)malloc(sizeof(struct line));
			morelns=morelns->next;
		}
	}
	morelns->ln=(char*)malloc(sizeof(char)*strlen(toadd)+1);
	strcpy(morelns->ln,toadd);
	morelns->len=strlen(morelns->ln);
}

void rmln(struct line* lines,int linenum){
	struct line* ptr;
	struct line* prv;
	int curnum;
	ptr=lines;
	prv=NULL;
	curnum=1;
	while((curnum!=linenum)&&(ptr!=NULL)){
		prv=ptr;
		ptr=ptr->next;
		curnum++;
	}
	if(ptr==NULL){
		printf("Error: Tried to delete an invalid line.\n\r");
		return;
	}
	if(prv=NULL){
		free(lines);
		return;
	}
	prv->next=ptr->next;
	lines->lineno--;
	free(ptr->ln);
	free(ptr);
}

void echo(struct line* lines){
	struct line* ptr=lines;
	printf(HEADER);
	printf(autoinsert);
	while(ptr!=NULL){
		if(ptr->ln==NULL)
			return;
		printf(ptr->ln);
		printf("\n");
		ptr=ptr->next;
	}
}
