#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "fileio.h"

extern char* autoinsert;
void edit(char* file);
void menu();
void prompt(struct line* toedit);
void startup(struct line* toedit);
void aliases(struct line* toedit);
void help();
void pager();
void cls();
void linebyline(struct line* toedit);

void pager(){
	char wait[3];
	printf("<Hit Enter to Continue>\n\r");
	gets(wait);
}

void cls(){
	printf("\033[H\033[J");
}

void help(){
	cls();
	printf(
"  Welcome to the INSANITY Shell Configuration Program.  This program is\n\r"
"designed to help people who don't really don't know how to configure \n\r"
"UNIX shells.\n\r"
"  For those of you who don't know, the UNIX shell is where you actually\n\r"
"type in commands.  Normally, it looks something like this:\n\r"
"machinename%\n\r"
"  That's rather dull, isn't it?  The purpose of this program is to help\n\r"
"you spiff up your shell and make people think you actually know some neat\n\r"
"UNIX commands.  If you already know neat UNIX commands, then you can still\n\r"
"use this as a tool to help your customizations go faster.\n\r");
	pager();
	cls();
	printf(
"  There are several basic functions this program preforms.  First, it\n\r"
"helps you create a neat looking prompt.  Prompts consist of text and\n\r"
"'%%'s followed by a letter (ie %%t) that are replaced with things such\n\r"
"as the time, date, or whatever, depending on the code used.  A list of\n\r"
"codes that I know of will be shown to you when you edit your prompt.\n\r"
"  Next, you can have your session load several programs when you log in.\n\r"
"Typical programs used are 'w' (lists users online), 'quota' (checks your\n\r"
"disk allocation on some systems), and 'znol' (if your network uses the\n\r"
"Athena Zephry system).  I would not advise running any applications, such\n\r"
"as 'pine' (email program) or anything of the like, especially if you are\n\r"
"using Xterms.  Please note that if words like 'Xterm' and 'Zephry'\n\r"
"comfuse you, that simply means you probably don't use them.  :-)\n\r"
"  Lastly, you can make user-defined commands, called 'aliases'.  These\n\r"
"are simply shortcuts you make to run programs, switch to directories\n\r"
"with exsesively long paths, or in general make life easier.  For example,\n\r"
);
	pager();
	cls();
	printf(
"if I define an alias called 'pico', and defined it to run 'pico -w'\n\r"
"(that's the editor pico, disabling word wrap), then if I typed:\n\\n\rr"
"pico hello.txt\n\r"
"  It would REALLY run:\n\r"
"pico -w hello.txt\n\r\n\r"
"  See what I mean?  Anyway, if something comfuses you, then don't use\n\r"
"it.  If it ALL comfuses you, then quit the program :-)  Have fun!\n\r"
" -- Steve Conley, sconley@leo.leonine.com\n\r");
	pager();
}

void aliases(struct line* toedit){
	char input1[256];
	char input2[1000];
	char final[1270];
	cls();
	printf(
"Aliases are simply user-defined commands made to simpify life.\n\r"
"If you have to type a long command often, this'll help you out.\n\r"
"I like to alias 'ls' to 'ls -aF' myself, and I also like 'cls'\n\r"
"to 'clear'.  See help for more information, and examples.\n\r"
);
	while(1){
		printf("\n\rType in the command you want to make below, or . to quit.\n\r");
		gets(input1);
		if((input1[0]=='.')&&(input1[1]=='\0')){
			printf("\n\r");
			return;
		}
		printf("\n\rWhat does this alias execute?\n\r");
		gets(input2);
		sprintf(final,"alias %s '%s'",input1,input2);
		addln(toedit,final);
	}
}

void startup(struct line* toedit){
	char input[8000];
	cls();
	printf(
"This allows you to choose a list of programs you want to run\n\r"
"automatically when you log in.  Having a list of people you want\n\r"
"to finger, 'w', 'quota', and the like are good things to have here.\n\r"
"Start typing what you want to boot up in, finishing with a '.' on a\n\r"
"line by itself.  See the help for more information.\n\r"
);
	while(1){
		printf("\n\r> ");
		gets(input);
		if((input[0]=='.')&&(input[1]=='\0')){
			printf("\n\r");
			return;
		}
		addln(toedit,input);
	}
}

void menu(){
	cls();
	printf("Project INSANITY Presents -- The INSANITY C-Shell Configuration Editor\n\r");
	printf("-(By: Steve Conley, sconley@leo.leonine.com)-------------------------\n\r");
	printf("This is a editor to set up the look and feel of your login sessions.\n\r");
	printf("Simply pick what you want to edit below.\n\r");
	printf(
"\n\r"
"  1) Edit your prompt\n\r"
"  2) Edit your startup programs\n\r"
"  3) Edit your alias list\n\r"
"  4) View your configuration file\n\r"
"  5) Get help\n\r"
"  6) Exit\n\r");
	printf("\n\r> ");
}

void prompt(struct line* toedit){
	char input[256];
	char final[271];
	cls();
	printf(
"Your prompt is a very important part of how your configuration looks.\n\r"
"It needs to be not too long, and it should have any commonly needed\n\r"
"information, such as date/time, current directory path, etc.  A prompt\n\r"
"consists of text without any \", ', !, or & in them.  You can include\n\r"
"certain strings in your prompt that will be replaced by information.\n\r"
"Here are some commonly-used strings you can put in your prompt:\n\r"
);
	pager();
	cls();
	printf(
"    %%   -- Just %%\n\r"
"    %%m  -- Name of the machine you are on\n\r"
"    %%M  -- Full name of the machine you are on\n\r"
"    %%t  -- Time, in 12hour clock format.\n\r"
"    %%T  -- Time, in 24hour clock format.\n\r"
"    %%C  -- Current directory\n\r"
"    %%~  -- Current directory path\n\r"
"    %%d  -- Abreviation of current day\n\r"
"    %%D  -- Number of the day\n\r"
"    %%n  -- Your login ID.\n\r"
"    %%p  -- Time, with seconds (12 hr)\n\r"
"    %%P  -- Time, with seconds (24 hr)\n\r"
"    %%x  -- Abreviation of the month\n\r"
"    %%Y  -- The year\n\r"
"(Example: [%%t][%%~]> would look something like [12:25pm][~]>)\n\r"
"Input your prompt here: "
);
	gets(input);
	printf("\n\r");
	sprintf(final,"set prompt=\"%s\"",input);
	addln(toedit,final);
}

void linebyline(struct line* toedit){
	struct line* prv=NULL;
	struct line* cur=toedit;
	char tmp[3];
	cls();
	printf(
"Would you like to delete lines from your current configuration file?\n\r"
"(Y/n): ");
	gets(tmp);
	switch(tmp[0]){
	case 'n':
	case 'N': printf("Skipping...\n\r");
		  return;
	default:
	}
	cls();
	printf(
"The program will now go through the file, line by line.  Anything of the\n\r"
"format 'set prompt=\"....\"' is something to set a prompt, anything of\n\r"
"the format 'alias something '....'' is an alias, where something is the\n\r"
"name of the alias, and everything else is either user-defined or put in\n\r"
"automatically by the system.  It's O.K. to delete anything put in by the\n\r"
"system, because it will be put back in automatically when you exit the\n\r"
"program.  The following, from here until the <hit enter to continue>, is\n\r"
"inserted by the system:\n\r%s\n\r",autoinsert);
	pager();
	cls();
	while(cur!=NULL){
		printf("%s\n\r",cur->ln);
		printf("Delete line? y/N: ");
		gets(tmp);
		switch(tmp[0]){
		case 'y':
		case 'Y':
			if(prv==NULL){
				toedit=cur->next;
				free(cur->ln);
				free(cur);
				cur=toedit;
			}else{
				prv->next=cur->next;
				free(cur->ln);
				free(cur);
				cur=prv->next;
		
			}
			break;
		default:
			prv=cur;
			cur=cur->next;
		}
	}
}

void edit(char* file){
	FILE* tmp;
	struct line* myfile=NULL;
	char min[3];
	tmp=fopen(file,"rw");
	if(!tmp){
		myfile=(struct line*)malloc(sizeof(struct line));
		myfile->next=NULL;
		if(myfile==NULL){
			printf("FATAL ERROR!  Could not allocate enough memory!\n\r");
			exit(1);
		}
	}else{
		fclose(tmp);
		myfile=(struct line*)malloc(sizeof(struct line));
		myfile->next=NULL;
		readin(file,myfile);
		linebyline(myfile);
	}
	while(1){
		menu();
		gets(min);
		switch(min[0]){
		case '1': /* Edit prompt */
			prompt(myfile);
			break;
		case '2': /* Edit the startup lines */
			startup(myfile);
			break;
		case '3': /* Edit aliases */
			aliases(myfile);
			break;
		case '4': /* View file */
			cls();
			echo(myfile);
			pager();
			break;
		case '5': /* HELP! */
			help();
			break;
		case '6': /* Quit */
			save(myfile,file);
			printf("Bye!\n\r");
			return;
		default: printf("Huh?\n\r");
		}
	}
}
