/*
 * Copyright (c) 1998 by David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * Definitions for stand-alone shell for system maintainance for Linux.
 */

#ifndef	KISS_H
#define	KISS_H


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <time.h>
#include <ctype.h>


#define	PATHLEN		1024
#define	CMDLEN		10240
#define	MAXARGS		1000
#define	ALIASALLOC	20
#define	STDIN		0
#define	STDOUT		1
#define	MAXSOURCE	10
#define	BUFSIZE		8192


#ifndef	isblank
#define	isblank(ch)	(((ch) == ' ') || ((ch) == '\t'))
#endif

#define	isquote(ch)	(((ch) == '"') || ((ch) == '\''))
#define	isdecimal(ch)	(((ch) >= '0') && ((ch) <= '9'))
#define	isoctal(ch)	(((ch) >= '0') && ((ch) <= '7'))


typedef	int	BOOL;

#define	FALSE	((BOOL) 0)
#define	TRUE	((BOOL) 1)


/*
 * Macro to use function prototypes if this is an ANSI compiler.
 */
#ifdef	__STDC__
#define	PROTO(a)	a
#else
#define	const
#define	PROTO(a)	()
#endif


/*
 * Built-in command functions.
 */
extern	void	do_alias PROTO((int argc, const char ** argv));
extern	void	do_cd PROTO((int argc, const char ** argv));
extern	void	do_exec PROTO((int argc, const char ** argv));
extern	void	do_exit PROTO((int argc, const char ** argv));
extern	void	do_prompt PROTO((int argc, const char ** argv));
extern	void	do_source PROTO((int argc, const char ** argv));
extern	void	do_umask PROTO((int argc, const char ** argv));
extern	void	do_unalias PROTO((int argc, const char ** argv));
extern	void	do_help PROTO((int argc, const char ** argv));
extern	void	do_ln PROTO((int argc, const char ** argv));
extern	void	do_cp PROTO((int argc, const char ** argv));
extern	void	do_mv PROTO((int argc, const char ** argv));
extern	void	do_rm PROTO((int argc, const char ** argv));
extern	void	do_chmod PROTO((int argc, const char ** argv));
extern	void	do_mkdir PROTO((int argc, const char ** argv));
extern	void	do_rmdir PROTO((int argc, const char ** argv));
extern	void	do_mknod PROTO((int argc, const char ** argv));
extern	void	do_chown PROTO((int argc, const char ** argv));
extern	void	do_chgrp PROTO((int argc, const char ** argv));
extern	void	do_sync PROTO((int argc, const char ** argv));
extern	void	do_printenv PROTO((int argc, const char ** argv));
extern	void	do_more PROTO((int argc, const char ** argv));
extern	void	do_cmp PROTO((int argc, const char ** argv));
extern	void	do_touch PROTO((int argc, const char ** argv));
extern	void	do_ls PROTO((int argc, const char ** argv));
extern	void	do_dd PROTO((int argc, const char ** argv));
extern	void	do_tar PROTO((int argc, const char ** argv));
extern	void	do_mount PROTO((int argc, const char ** argv));
extern	void	do_umount PROTO((int argc, const char ** argv));
extern	void	do_setenv PROTO((int argc, const char ** argv));
extern	void	do_pwd PROTO((int argc, const char ** argv));
extern	void	do_echo PROTO((int argc, const char ** argv));
extern	void	do_kill PROTO((int argc, const char ** argv));
extern	void	do_grep PROTO((int argc, const char ** argv));
extern	void	do_ed PROTO((int argc, const char ** argv));
extern	void	do_gzip PROTO((int argc, const char ** argv));
extern	void	do_gunzip PROTO((int argc, const char ** argv));
extern	void	do_where PROTO((int argc, const char ** argv));


/*
 * Global utility routines.
 */
extern	const char *	modestring PROTO((int mode));
extern	const char *	timestring PROTO((time_t timeval));
extern	BOOL		isadir PROTO((const char * name));
extern	int		namesort PROTO((const void * p1, const void * p2));
extern	char *		getchunk PROTO((int size));
extern	char *		chunkstrdup PROTO((const char *));
extern	void		freechunks PROTO((void));
extern	int		fullWrite PROTO((int fd, const char * buf, int len));
extern	BOOL		match PROTO((const char * text, const char * pattern));

extern	const char *	buildname
	PROTO((const char * dirname, const char * filename));

extern	BOOL	makeargs
	PROTO((const char * cmd, int * argcptr, const char *** argvptr));

extern	BOOL	copyfile
	PROTO((const char * srcname, const char * destname, BOOL setmodes));

extern	BOOL	makestring
	PROTO((int argc, const char ** argv, char * buf, int buflen));

extern	int	expandwildcards
	PROTO((const char *name, int maxargc, const char * retargv[]));



/*
 * Global variable to indicate that an SIGINT occurred.
 * This is used to stop processing.
 */
extern	BOOL	intflag;

#endif

/* END CODE */
