#ifndef TYPES
#define TYPES

#include <sys/time.h>           /* struct timeval                            */


/*-----------------------------------
Type safe(r) malloc and NULL variants
-----------------------------------*/

#define NEW(t) ((t*)malloc(sizeof(t)))  /* A ptr to a new instance of type t */
#define NIL(t) ((t*)NULL)               /* A NULL pointer of type (t*)       */


/*-----------------------------------------------
Ordinary boolean in hopes of better type checking
-----------------------------------------------*/

typedef unsigned char bool;     /* Yes or no                                 */

#define false ((bool)0!=0)      /* No!                                       */
#define true  ((bool)0==0)      /* Yes.                                      */


/*--------------------------------------------
A range of time values (can be hung in a list)
--------------------------------------------*/

typedef struct _range
{   struct _range *next;        /* Link to next in list                      */
    struct timeval min;         /* Time at which range becomes valid         */
    struct timeval max;         /* Time at which range becomes invalid       */
} range;


/*----------------------------------------
An interval (set of ranges), also listable
----------------------------------------*/

typedef struct _interval
{   struct _interval *next;     /* Link to next in list                      */
    range *ranges;              /* List of ranges comprising this interval   */
} interval;


/*----------------------------------------
A rule connecting ring sequence to command
----------------------------------------*/

typedef struct _ringseq
{   struct _ringseq *next;      /* Link to next in list                      */
    unsigned long id;           /* Sequence number of rule                   */
    struct timeval initial;     /* Initial guard time                        */
    struct timeval final;       /* Final guard time                          */
    interval *intervals;        /* List of inter-ring intervals              */
    char *command;              /* Command to run                            */
} ringseq;


#endif
