#ifndef TIMEVAL
#define TIMEVAL

#include "types.h"


/* Less-or-equal on struct timeval's */
#define tv_leq(tv1,tv2) ((tv1)->tv_sec<(tv2)->tv_sec||((tv1)->tv_sec==(tv2)->tv_sec&&(tv1)->tv_usec<=(tv2)->tv_usec))

/* Less-than on struct timeval's */
#define tv_lt(tv1,tv2) ((tv1)->tv_sec<(tv2)->tv_sec||((tv1)->tv_sec==(tv2)->tv_sec&&(tv1)->tv_usec<(tv2)->tv_usec))

/* Copy a struct timeval */
#define tv_copy(dst,src) ((dst)->tv_sec=(src)->tv_sec,(dst)->tv_usec=(src)->tv_usec,(dst))


/* Add two struct timeval's */
extern void tv_add(struct timeval *, struct timeval const *, struct timeval const *);

/* Subtract two struct timeval's */
extern void tv_subtract(struct timeval *, struct timeval const *, struct timeval const *);

/* Find a range that a struct timeval falls in */
extern range *tv_findrange(interval *,struct timeval const *);

/* Decode a floating point representation into a struct timeval */
extern bool decode_time(struct timeval *, const char *);


#endif
