#include <ctype.h>
#include <limits.h>
#include "timeval.h"
#include "log.h"

/* Secret usage of the parser error counter */
/* Is there an official way to use this thing? */

extern int yynerrs;

/* Maximal values for struct timeval members */

#define TV_SEC_MAX  LONG_MAX
#define TV_USEC_MAX 999999

/*------------------------
Add in2 and in1 giving out
No overflow check
Arguments may be shared
------------------------*/

extern void tv_add(struct timeval *out, struct timeval const *in1, struct timeval const *in2)
{   struct timeval sum;
    sum.tv_usec = in1->tv_usec + in2->tv_usec;
    sum.tv_sec = in1->tv_sec + in2->tv_sec + sum.tv_usec/(TV_USEC_MAX+1);
    out->tv_usec = sum.tv_usec%(TV_USEC_MAX+1);
    out->tv_sec = sum.tv_sec;
}

/*------------------------------
Subtract in2 from in1 giving out
No overflow check
Arguments may be shared
------------------------------*/

extern void tv_subtract(struct timeval *out, struct timeval const *in1, struct timeval const *in2)
{   struct timeval diff;
    diff.tv_usec = (TV_USEC_MAX+1) + in1->tv_usec - in2->tv_usec;
    diff.tv_sec = in1->tv_sec - in2->tv_sec + diff.tv_usec/(TV_USEC_MAX+1) - 1;
    out->tv_usec = diff.tv_usec%(TV_USEC_MAX+1);
    out->tv_sec = diff.tv_sec;
}

/*-------------------------------------------------
Find time tv in the ranges of interval i
Return applicable range, or NIL(range) if not found
-------------------------------------------------*/

extern range *tv_findrange(interval *i,struct timeval const *tv)
{   range *r;
    r = i->ranges;
    while (r && (tv_lt(tv,&r->min) || tv_leq(&r->max,tv)))
        r = r->next;
    return r;
}

/*------------------------------------------
Decode a string of the form [0-9]*(.[0-9]*)?
String must have correct syntax
Result is a struct timeval
Return true on success, false on overflow
------------------------------------------*/

bool decode_time(struct timeval *tv, char const *str)
{   char const *c = str;
    struct timeval ltv;

    /* Decode integer part */
    ltv.tv_sec = 0;
    for (c = str; isdigit(*c); c++)
    {   int d = *c-'0';
        if ((TV_SEC_MAX-d)/10<ltv.tv_sec)
        {   tv->tv_sec  = TV_SEC_MAX;
            tv->tv_usec = TV_USEC_MAX;
            log(LL_ERR, "Overflow in time representation: %s", str);
            return false;
        }
        ltv.tv_sec = ltv.tv_sec*10+d;
    }

    /* Decode fraction */
    ltv.tv_usec = 0;
    if (*c=='.')
    {   int i;
        c++;
        for (i=0; i<6; i++)
            ltv.tv_usec = ltv.tv_usec*10L+(long)(*c?*c++-'0':0);
        /* Silently truncate remaining fraction */
    }

    /* Return */
    tv->tv_sec  = ltv.tv_sec;
    tv->tv_usec = ltv.tv_usec;
    return true;
}
