%{

#include <stdlib.h>
#include <string.h>
#include "timeval.h"
#include "log.h"
#include "semantics.h"

/* We steal these from the scanner */
extern int yylex(void);

#define yyerror(msg) (log(LL_ERR, "%s", (msg)))
#define YYDEBUG 1
#define YYERROR_VERBOSE 1

%}

%union {
struct timeval   at_time;
interval       * at_interval;
range          * at_range;
char           * at_string;
int              at_cardinal;
}

%type <at_time>         guard time
%type <at_interval>     intervals
%type <at_range>        ranges range

%token JOINTIME
%token LOGLEVEL
%token MODEMDEVICE
%token SHELL

%token EQUALS
%token RING
%token OR
%token TO

%token <at_string>   STRING
%token <at_time>     TIME
%token <at_cardinal> CARDINAL

%%

input : input line  ;
input : input error ;
input :             ;

line : guard intervals guard EQUALS STRING   { configrule(mkrule(&$1,$2,&$3,$5)); } ;
line : JOINTIME              EQUALS time     { configjointime(&$3);               } ;
line : LOGLEVEL              EQUALS CARDINAL { configloglevel($3);                } ;
line : MODEMDEVICE           EQUALS STRING   { configmodemdevice($3);             } ;
line : SHELL                 EQUALS STRING   { configshell($3);                   } ;

guard : time { (void)tv_copy(&$$, &$1); } ;
guard :      { maketime(&$$, 0, 0); }     ;

intervals : RING                  { $$ = NIL(interval); }                    ;
intervals : intervals ranges RING { $$ = catintervals($1, mkinterval($2)); } ;

ranges :           range { $$ = catranges(NIL(range), $1); }                ;
ranges : ranges OR range { checkoverlaps($1, $3); $$ = catranges($1, $3); } ;

range : time TO time { $$ = mkrange(&$1, &$3); } ;

time : TIME     { (void)tv_copy(&$$, &$1); } ;
time : CARDINAL { maketime(&$$, $1, 0); }    ;
