#ifndef SIGNALS
#define SIGNALS

#include <signal.h>

/*----------------------------------------------------------------------
Install function `handler' as signal handler for signal `signum'. `mask'
is the set of signals to block when `signum' is handled. `Flags' are the
sig_action flags. Save the old setting in `sa_save'. If successful, add
`signum' to the set of handled signals `ss_handled'.
----------------------------------------------------------------------*/
extern void sa_set(int, void (*handler)(int), sigset_t const *, int, struct sigaction *, sigset_t *);

/* Restore signal if it was handled */
extern void sa_reset(int, struct sigaction *, sigset_t const *);

#endif
