#ifndef SEMANTICS
#define SEMANTICS

#include "types.h"

/* Number of times some settings occur in config file */
extern unsigned jointimecount;
extern unsigned loglevelcount;
extern unsigned modemdevicecount;
extern unsigned shellcount;
extern unsigned nwarnings;

/* Settings from config file */
extern char                * config_modemdevice;
extern char           const* config_nulldevice;
extern ringseq             * config_program;
extern char                * config_shell;
extern struct timeval        config_jointime;
extern int                   config_loglevel;

/* Configuration file lines */
extern void configrule(ringseq *);
extern void configjointime(struct timeval const*);
extern void configloglevel(int);
extern void configmodemdevice(char *);
extern void configshell(char *);

/* Additional configuration semantics */
extern ringseq *mkrule(struct timeval const*, interval *, struct timeval const*, char *);
extern void maketime(struct timeval *, long, long);
extern interval *catintervals(interval *, interval *);
extern interval *mkinterval(range *);
extern void checkoverlaps(range const*, range const*);
extern range *catranges(range *, range *);
extern range *mkrange(struct timeval const*, struct timeval const*);

#endif
