#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "rs.h"
#include "timeval.h"
#include "log.h"
#include "semantics.h"

unsigned jointimecount;
unsigned loglevelcount;
unsigned modemdevicecount;
unsigned shellcount;
unsigned nwarnings;

char                * config_modemdevice;
char           const* config_nulldevice;
ringseq             * config_program;
char                * config_shell;
struct timeval        config_jointime;
int                   config_loglevel;

/* Steal from parser */
extern int yynerrs;

/* Define a rule from the configuration file */
void configrule(ringseq * r)
{   ringseq ** rr;
    for (rr = &config_program; *rr; rr = &(*rr)->next);
    *rr = r;
}

/* Define the join time from the configuration file */
void configjointime(struct timeval const* jointime)
{   if (jointimecount++==0)
        tv_copy(&config_jointime, jointime);
}

/* Define the log level from the configuration file */
void configloglevel(int loglevel)
{   if (loglevel<0 || loglevel>LL_MAX)
    {   log(LL_ERR, "loglevel %ld is invalid", loglevel);
        yynerrs++;
    }
    if (loglevelcount++==0)
        config_loglevel = (unsigned short)loglevel;
}

/* Define the modem device from the configuration file */
void configmodemdevice(char * modemdevice)
{   if (modemdevicecount++==0)
        config_modemdevice = modemdevice;
}

/* Define the shell from the configuration file */
void configshell(char * shell)
{   if (shellcount++==0)
        config_shell = shell;
}

/* Construct a rule from its constituents */
ringseq *mkrule(struct timeval const *ini, interval *intv, struct timeval const *fin, char *command)
{   ringseq *r;
    r = newringseq(ini->tv_sec, ini->tv_usec, intv, fin->tv_sec, fin->tv_usec, command);
    return r;
}

/* Construct a timeval structure from its constituents */
void maketime(struct timeval *tv, long sec, long usec)
{   tv->tv_sec = sec;
    tv->tv_usec = usec;
}

/* Catenate two intervals */
interval *catintervals(interval *i1, interval *i2)
{   interval **ii;
    for (ii = &i1; *ii; ii = &(*ii)->next);
    *ii = i2;
    return i1;
}

/* Construct an interval from its constituents */
interval *mkinterval(range *r)
{   return newinterval(NIL(interval), r);
}

/* Check two ranges for overlaps as service to the user */
void checkoverlaps(range const* r1, range const* r2)
{   for (; r1; r1 = r1->next)
        for (; r2; r2 = r2->next)
            if (tv_lt(&r2->min, &r1->max) && tv_lt(&r1->min, &r2->max))
                log( LL_WARNING,
                     "Warning, ranges %ld.%06ld-%ld.%06ld and %ld.%06ld-%ld.%06ld overlap",
                     r1->min.tv_sec, r1->min.tv_usec,
                     r1->max.tv_sec, r1->max.tv_usec,
                     r2->min.tv_sec, r2->min.tv_usec,
                     r2->max.tv_sec, r2->max.tv_usec );
}

/* Catenate two ranges */
range *catranges(range *r1, range *r2)
{   range **rr;
    for (rr = &r1; *rr; rr = &(*rr)->next);
    *rr = r2;
    return r1;
}

/* Construct a range from its constituents */
range *mkrange(struct timeval const *tv1, struct timeval const *tv2)
{   if (tv_leq(tv2, tv1))
    {   log( LL_WARNING, "Empty range %ld.%06ld-%ld.%06ld ignored",
             tv1->tv_sec, tv1->tv_usec, tv2->tv_sec, tv2->tv_usec );
        return NIL(range);
    }
    return newrange(NIL(range), tv1->tv_sec, tv1->tv_usec, tv2->tv_sec, tv2->tv_usec);
}
