#ifndef LOG
#define LOG

#include <sys/types.h>

#define LL_DEBUG   0
#define LL_INFO    1
#define LL_NOTICE  2
#define LL_WARNING 3
#define LL_ERR     4
#define LL_CRIT    5
#define LL_ALERT   6
#define LL_EMERG   7
#define LL_MAX     8

extern void log(int, char const*, ...);
/* Log printf-like message with specified severity */

extern pid_t become_daemon(void);
/* Spawns self into background, start logging to syslog */

#endif
