%{
#include <limits.h>
#include "timeval.h"
#include "decode.h"
#include "log.h"
#include "semantics.h"
#include "syntax.tab.h"
extern int yynerrs;
%}
%option noyywrap
%option nounput
TIME	([0-9]+|[0-9]+\.[0-9]*|[0-9]*\.[0-9]+)
STRCHR	\\.|[^\\\n"]
STR	\"{STRCHR}*\"
WORD	[a-zA-Z]+
WS	[ \f\n\r\t\v]+
%%
{WS}
#[^\n]*
=	return EQUALS;
\*	return RING;
,	return OR;
-	return TO;
{WORD}	{int i; if(!decode_word(yytext,&i))yynerrs++; else return i;}
{STR}	yylval.at_string = decode_string(yytext); return STRING;
[0-9]+	if (!decode_int(yytext, INT_MAX, &yylval.at_cardinal)) yynerrs++; return CARDINAL;
{TIME}	if (!decode_time(&yylval.at_time, yytext)) yynerrs++; return TIME;
.	log(LL_ERR, "Unexpected character: '%c'", yytext[0]);yynerrs++;
