#ifndef CONFIG
#define CONFIG

#include "types.h"

extern char const* configfile;  /* Where configurations are found             */
extern char const* modemdevice; /* Modem device to listen to                  */
extern char const* nulldevice;  /* Null device for command I/O redirection    */
extern char const* pidfile;     /* File to write pid to when backgrounding    */
extern ringseq * program;       /* Set of ringsequence-command rules          */
extern int runmode;             /* How to run (daemon-foreground-syntax-help) */
extern char const* self;        /* What we call ourselves (argv[0])           */
extern char const* shell;       /* Shell to execute commands with -c          */
extern struct timeval jointime; /* Minimal time to keep rings apart           */
extern int loglevel;            /* How much to log                            */

extern void scan_options(int, char *const*);
/* Scans argv for options */

extern bool read_configfile(void);
/* Reads the configuration file for rules & options */
/* Returns whether succesful */

#endif
