/******************************************************************

 Modem Status lights for Linux console
 Public Domain 1995 by Doug McLean (madsci@mi.net)

 This simple program uses ANSI to put a serial status bar at the
 top of a Linux terminal. It is very simple and uses ANSI rather
 than curses.

******************************************************************/ 

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/ioctl.h>
   
#define RED 1
#define GRN 2
#define YEL 3
#define BLU 4
#define PUR 5
#define CYN 6
#define WHT 7
#define BLK 0

#define RESET      "\033[0m"
#define BOLD       "\033[1m"
#define SAVE       "\033[s"
#define RESTORE    "\033[u"
#define CLR2TOP    "\033[1J"

void          set_col(char,char);
void          position(int,int);
void          usage(char *);
void          open_my_device();

char          rts_c,cts_c,dsr_c,cd_c,dtr_c,ring_c;
char          device[255];
char          dispdev[128];
char          *tbuff;
char          dtitle;
int           fh;
unsigned int  status;
unsigned int  ioret;
pid_t         me;

#define       RMARG  71

char          *version = "\nmodemstat v0.2 public domain 1995 by Doug McLean (madsci@mi.net)\n";

void main(int argc, char *argv[])
{
	puts (version);
        if (argc > 2)    usage   (argv[0]);
        if (argc != 2)   strcpy  (device,"/dev/modem");
        else             strcpy  (device,argv[1]);


        switch(fork())
        {
           case 0:
              setsid();
              break;
              
           case -1:
              printf("%s: can't fork.\n", argv[0]);
              exit(1);
              
           default:
              exit(0);
        }

        tbuff = device;
        while ((tbuff = strchr(tbuff,'/'))!=NULL) strcpy (dispdev,++tbuff);
        dispdev[8]=0x00;

     	open_my_device();
     	me = getpid();
     	dtitle = 0;

        for (;;)
        {

                status = ioctl (fh, TIOCMGET, &ioret);

        	if (status == 0)
        	{
        	   if (ioret & TIOCM_RTS) rts_c  = GRN;
        	                     else rts_c  = RED;
        	   if (ioret & TIOCM_CTS) cts_c  = GRN;
        	                     else cts_c  = RED;
        	   if (ioret & TIOCM_DSR) dsr_c  = GRN;
        	                     else dsr_c  = RED;
        	   if (ioret & TIOCM_CAR) cd_c   = GRN;
        	                     else cd_c   = RED;
        	   if (ioret & TIOCM_DTR) dtr_c  = GRN;
        	                     else dtr_c  = RED;
        	   if (ioret & TIOCM_RNG) ring_c = GRN;
        	                     else ring_c = RED;
        	}
        	else
        	{
        	   close(fh);
        	   rts_c   = YEL;
        	   cts_c   = YEL;
        	   dsr_c   = YEL;
        	   cd_c    = YEL;
        	   dtr_c   = YEL;
        	   ring_c  = YEL;
        	   open_my_device();
        	}

        	printf   (SAVE);
                printf   (BOLD);

        	position (1,RMARG);
        	
        	if (dtitle == 0)
        	{
        	      set_col  (CYN,BLU);
                      printf   (" %-8s ",dispdev);
                      dtitle += 1;
                }
                else if (dtitle == 1)
                {
                      set_col  (CYN,BLU);
                      printf   (" PID%5d ",me);
                      dtitle += 1;
                }
                else
                {
                      if (ioret & TIOCM_CAR)
                      {
                           set_col  (WHT,BLU);
                           printf   ("  ONLINE  ");
                      }
                      else
                      {
                           set_col  (YEL,BLU);
                           printf   (" OFFLINE  ");
                      }
                      dtitle = 0;
                }

                position (2,RMARG);
        	set_col  (rts_c,BLU);   printf (" RTS  ");
        	set_col  (cts_c,BLU);   printf ("CTS ");

        	position (3,RMARG);
        	set_col  (dsr_c,BLU);   printf (" DSR  ");
        	set_col  (dtr_c,BLU);   printf ("DTR ");

        	position (4,RMARG);
        	set_col  (cd_c,BLU);    printf (" CD   ");
        	set_col  (ring_c,BLU);  printf ("RNG ");

                
                printf   (RESTORE);
                printf   (RESET);
                set_col  (WHT,BLK);
                fflush   (stdout);
                sleep    (1);
        }
}


void usage(char *who)
{
	printf ("USAGE: %s [/dev/serial_device_name]\n",who);
	printf ("       Default device is /dev/modem\n");

}

void set_col(char fg_color,char bg_color)
{
   fg_color += 30; bg_color += 40;
   printf ("\033[%d;%dm",fg_color,bg_color);
}

void position (int line,int col)
{
   printf ("\033[%u;%uf",line,col);
}

void open_my_device()
{
   fh =  open (device,O_RDONLY);
   if    (fh == -1)
   {
         printf ("\nCannot open %s\n",device);
         exit (1);
   }
}
