/* DCF77-Funkuhr Empfangs-Decoder fuer Linux (c) 1996 by Michael Bosch
   some rewriting by Hans-Helmar Althaus (c) reserved for this */

#include "dcf77.h"

void dcf_unify_time(struct timeval *e)
{
  /* unify results of prev. unified adds and subs only ! */
  
  if(e->tv_usec < 0)
    { e->tv_usec += 1000000; e->tv_sec --; }
  else if(e->tv_usec >= 1000000)
    { e->tv_usec -= 1000000; e->tv_sec ++; }
}

void dcf_sub_time(struct timeval *e, struct timeval *a, struct timeval *b)
{
  e->tv_sec = a->tv_sec - b->tv_sec;
  e->tv_usec = a->tv_usec - b->tv_usec;
  dcf_unify_time(e);
}

void dcf_mov_time(struct timeval *e, struct timeval *a)
{
  e->tv_sec = a->tv_sec;
  e->tv_usec = a->tv_usec;
}

void dcf_add_time(struct timeval *e, struct timeval *a, struct timeval *b)
{
  e->tv_sec = a->tv_sec + b->tv_sec;
  e->tv_usec = a->tv_usec + b->tv_usec;
  dcf_unify_time(e);
}

int dcf_sub_abs_time(struct timeval *e, struct timeval *a, struct timeval *b)
{
  dcf_sub_time(e, a, b);
  if(e->tv_sec>=0) return 0;
  dcf_sub_time(e, b, a);
  return 1;
}

void print_time(struct timeval *t)
{
  printf("%d.%06d", (int) t->tv_sec, (int) t->tv_usec );
}

void print_delta(struct timeval *a,struct timeval *b)
{
  int sign;
  struct timeval delta;
  
  sign = dcf_sub_abs_time(&delta, a, b);
  printf ( "%c%d.%06d", sign? '-': '+', 
	   (int) delta.tv_sec, 
	   (int) delta.tv_usec );
}

void fprint_time( FILE *handle, struct timeval *t)
{
  fprintf ( handle, "%d.%06d", 
	    (int) t->tv_sec, 
	    (int) t->tv_usec );
}

/*
void fprint_ftime( FILE *handle, struct timeval *t)
{
  char date_buf[100];
  struct tm tm;

  strftime( date_buf, 100, "%a %d.%b.%Y %H:%M:%S", tm);

  fprintf( handle, "%s.%d", 
           date_buf, 
           (int) t->tv_usec );
}
*/

void fprint_delta( FILE *handle, struct timeval *a,struct timeval *b)
{
  int sign;
  struct timeval delta;
  
  sign = dcf_sub_abs_time(&delta, a, b);
  fprintf( handle, "%c%d.%06d", sign? '-': '+', 
	   (int) delta.tv_sec, 
	   (int) delta.tv_usec );
}

int dcf_test_parity( dcftype *dcfinfo )
{
  int i, j, p;
  
  for ( i= 0; i < psize; i++ )
    {
      p= 0;

      for ( j= parity[i].start; j <= parity[i].end; j++ )       
	{
	  p= ( p + dcfinfo->bit[j] ) & 1;	 
	}

      if ( debug > 2 )
	printf( "parity for %s was %d and should be %d \n",
		parity[i].desc, 
		p,
		dcfinfo->bit[parity[i].bit] );     
      
      if ( p != dcfinfo->bit[parity[i].bit] ) return FALSE;
    }
  
  return TRUE;
}

int dcf_get_timeval( dcftype *dcfinfo, struct timeval *dcft)
{
  /* this function will be called after 'bit 58' is received,
     it will return the decoded dcf-time-info, the following steps are
     'bit 59' will be empty the time is set a rising flank of 'bit 0' */
  
  int ziff[zsize];
  int i, z, j, k;
  /*  int wday, sign; */
  /*  struct tm timestrct; is global ! */
  
  if ( dcf_test_parity( dcfinfo ) == FALSE )
    {
      fprintf( stderr, "parity check of dcf-timeinfo failed\n");
      return FALSE;
    }
  
  for ( j= 0, i= 0; i < zsize; i++ )        
    {
      for ( z= 0, k= 0; k < zl[i]; j++, k++)
	z += ( dcfinfo->bit[j] & 1) << k;
      ziff[i] = z;
    }
  
  timestruct.tm_sec   = 0;
  timestruct.tm_min   =  ziff[1] + 10 *  ziff[2];
  timestruct.tm_hour  =  ziff[4] + 10 *  ziff[5];
  timestruct.tm_mday  =  ziff[7] + 10 *  ziff[8];
  timestruct.tm_mon   = ziff[10] + 10 * ziff[11] - 1;
  timestruct.tm_year  = ziff[12] + 10 * ziff[13];

  if ( timestruct.tm_year < 99 ) /* year 2000 fix */ 
    timestruct.tm_year+= 100;

  timestruct.tm_isdst = dcfinfo->bit[17] & 1 ? 1: -1; 
  /* IS DaylightSavingTime ? */

  /* wday = ziff[9]; */ /* day of week */
  
  if ( debug > 0 )
    {
      printf("received dcf-time-info is: ");
      printf("date: %2d.%2d.%4d, ", 
	     timestruct.tm_mday, 
	     timestruct.tm_mon + 1, 
	     timestruct.tm_year + 1900 );

      printf("time: %2d:%02d\n",
	     timestruct.tm_hour, 
	     timestruct.tm_min );
      
      for(i=0; i<statusbits; i++)        
	{
	  if(dcfinfo->bit[status[i].bit] == 1) 
	    printf("Status bit %d \"%s\" is set.\n",
		   status[i].bit,
		   status[i].desc);
	}
    }
  
  if ( ( dcft->tv_sec= mktime( &timestruct ) ) == -1 )
    {
      fprintf(stderr, "mktime from dcf-timeinfo failed\n" );
      return FALSE;
    }
  
  dcft->tv_usec= 0;
  
  return TRUE;
}

static inline int dcf_readbit(void)
{
  return ( ( ( inb(port) >> portbit )^ invertbit ) & 1 );
}

int dcf_status(int status, int max_counts, struct timeval *t)
{
  while( dcf_readbit() == status )
    {
      if ( max_counts-- == 0 ) return TIMEOUT;
      usleep( POLL_DISTANCE );
    }
  
  gettimeofday( t, NULL ); /* get time of bit-end */
  return 0;
}

int get_bitlen(struct timeval *t1, struct timeval *t2, int flag)
{
  /* wait for bit */
  if (flag == GETALL)
    if (dcf_status(DCF_SIGNAL,one_sec,t1) == TIMEOUT) 
      return TIMEOUT; 
  
  if (dcf_status(DCF_PAUSE,one_sec,t2) == TIMEOUT) 
    return TIMEOUT;
  
  /* calculate bit-length */
  dcf_sub_time(t2, t2, t1); /* t2 - t1 := t2 */
  
  /* decode dcf-bit */
  if(t2->tv_sec) return NODCFBIT;
  
  if(t2->tv_usec > DCF0BIT - DCFWIND && t2->tv_usec < DCF0BIT + DCFWIND ) 
    return 0;
  if(t2->tv_usec > DCF1BIT - DCFWIND && t2->tv_usec < DCF1BIT + DCFWIND ) 
    return 1;
  
  return NODCFBIT; /* bitlength is not valid dcf-transmission */
}

void init_sighandler()
{
  /* fetch the most popular signals,
     to softly bring down the program */
  
  if (signal(SIGTERM,&term) == SIG_ERR )
    fprintf(stderr,"Could not install SIGTERM handler.\n");
  
  if (signal(SIGINT,&term) == SIG_ERR )
    fprintf(stderr,"Could not install SIGINT handler.\n");
  
  if (signal(SIGHUP,&term) == SIG_ERR )
    fprintf(stderr,"Could not install SIGHUP handler.\n");
  
  if (debug > 3)
    printf("installed signal handler\n");
  
}

void term(int sig)
{
  fprintf(stderr,"received signal %d terminating.\n",sig);
  cont_loop= FALSE;
}

void dcf_poll(void)
{
  /* sync to dcf signal, decode dcf signal, then set systemclock 
     every hour using settimeofday, report delta to logfile. */
  
  int bit, sync= OFFSYNC;
  dcftype dcfinfo;
  struct timeval t0, t1, t2, t3, t4, dt;
  
  t0.tv_sec= t4.tv_usec= 0; /* last update, will be set after first update */
  t4.tv_sec= t4.tv_usec= 0; /* last telegram, */
  
  if ( debug > 3 ) 
    printf( "entering poll-loop\n" );
  
  if ( ioperm( port, 1, 1 ) ) /* check if we can read from port */
    { 
      fprintf( stderr, "no ioperm\n" ); 
      exit(1);
    }
  
  if ( debug > 3 ) 
    printf( "got ioperm\n" );
  
  init_sighandler(); /* use our own SIGTERM handler */
  
  while( cont_loop == TRUE )
    {
      if ( sync == 59 ) 
	{	
	  /* this is special t1 is still polled 
	     and the loop counter has to be reseted*/
	  bit= get_bitlen( &t1, &t2, USET1 ); /* returns result in t2 */
	  sync= 0;
	}
      else
	bit= get_bitlen( &t1, &t2, GETALL ); /* returns result in t2 */
      
      if ( debug > 2 )
	{
	  printf("sync= %2d, start= ",sync); print_time(&t1);
	  printf(" sec, length= "); print_time(&t2);
	  printf(" sec -> bit= %2d\n",bit);
	}
      
      if (bit != NODCFBIT)
	{
	  if (bit == TIMEOUT && sync == OFFSYNC ) 
            sync= 0;
	  else
            if (sync != OFFSYNC && (bit == 0 || bit == 1)) 
	      dcfinfo.bit[sync++]= bit;
            else sync= OFFSYNC;
	}
      else /* NODCFBIT */
	sync= OFFSYNC;
      
      if ( sync == 59 ) /* reached one min - 2sec */
	{
	  if ( debug > 1 )
	    printf("Time telegram received, checking and waiting\n");

	  if ( dcf_get_timeval( &dcfinfo, &t3 ) == TRUE )
	    {
	      /* check if we get a transmission at next second */ 
	      if ( dcf_status( DCF_SIGNAL, one_sec, &t1 ) == TIMEOUT )
		{
		  if ( debug > 1 )
		    printf( "got the 59 sec timeout\n" );
		  
		  if ( dcf_status( DCF_SIGNAL, one_sec, &t1 ) != TIMEOUT )
		    {
		      /* if the previous call didn't get a timeout,
			 t1 has the sysvalue of the beginning new second */
		      
		      dcf_sub_time( &dt, &t3, &t4 ); /* dt is diff to last */
		      
		      if( debug > 1 )
			{
			  printf("Diff to last telegram: ");
			  fprint_time(stdout, &dt);
			  printf("\n");
			}
		      
		      /* check the reliability of the decoded telegram */
		      
		      if ( dt.tv_sec == 60 ) /* last 60 sec before ? */
			{
			  /* ok we can use the telegram */
			  
			  dcf_sub_time(&dt,&t1,&t3); /* sysclk is dt away ! */
			  
			  /* do the updeate if we more than 10 sec away, or if
			     the last update was more than 2 hours ago. settime
			     will be FALSE if -q was used in commandline. */
			  
			  if ( dt.tv_sec > 10 || dt.tv_sec < -10 || /* 10sec */
			       t3.tv_sec - t0.tv_sec >= 3600 ) /* or 1hour */
			    {
 
    if ( settime == TRUE ) /* do it ? */
      {
	settimeofday( &t3, NULL ); /* set sysclock */
	
	if ( debug > 0 )		
	  printf("I did settimeofday(dcf).\n");
	
	if ( fp_data != NULL )
	  {
	    fprintf(fp_data,"set sysclk to: ");
	    fprintf(fp_data,"date: %2d.%2d.%4d, ", 
		    timestruct.tm_mday,
		    timestruct.tm_mon + 1,
		    timestruct.tm_year + 1900 );
	    fprintf(fp_data,"time: %2d:%02d:00",
		    timestruct.tm_hour,
		    timestruct.tm_min);
	    fprintf(fp_data,", offset: ");
	    fprint_time(fp_data, &dt);
	    fprintf(fp_data," done.\n");
	    fflush(fp_data);
	    dcf_mov_time( &t1, &t3 ); /* t3 -> t1 */
	  }
      }
    else
      printf("I would have done "
	     "settimeofday(dcf)\n");
    
    dcf_mov_time( &t0, &t3 ); /* cp last updt */
  }
			  
			  if ( debug > 1 )
			    {
			      printf("dt = "); print_time(&t0);
			      printf(" sec (sys) - "); print_time(&t3);
			      printf(" sec (dcf) = "); print_time(&dt); 
			      printf(" sec\n");

			    }

			}
		      else /* 60 secs ? */
			fprintf(stderr,"decoded time not 60 sec bound.\n");
		      
		      dcf_mov_time( &t4, &t3 ); /* cp last rec. telegram */
		      
		    }
		} /* TIMEOUT */
	      else 
		sync= OFFSYNC;

	    } /* valid dcftime */

	} /* second '60' */

    } /* continue */
  
  if ( fp_data != NULL ) 
    {
      fprintf(fp_data,"terminating dcf77\n");
      fclose(fp_data);
    }
  
  if (settime==TRUE) /* settime needs lockfile */
    if (unlink(pidfile)!=0)
      fprintf(stderr,"failed to remove pidfile\n");
  
  exit(0);
}

void usage(int err)
{
  printf("usage: %s [options]\n",command);
  printf( " -h  some helpfull information:\n");
  printf( " -s SOURCE set DCF77 source to one of:\n");
  printf( "      port:port[[,bit],inv]\n");
  printf( "      use bit \"bit\"at io address \"port\" \n");
  printf( "      and set \"inv\" to invert \"bit\"\n");
  printf( "      Default is -s port:0x%x,%d,%d\n",PORT,PORTBIT,INVERTBIT);
  printf( " -p PIDFILE store pid in this file.\n");
  printf( "    (default: \"%s\")\n",PIDFILE);
  printf( " -l LOGFILE log sysclock updates to this file.\n");
  printf( "    (default: \"%s\")\n",LOGFILE);
  printf( " -d DEBUGLEVEL set debuglevel to 0-4\n");
  printf( "    0: quit mode.\n");
  printf( "    1: inform about sysclockupdates.\n");
  printf( "    2: prompt telegram information.\n");
  printf( "    3: write loopstatus.\n");
  printf( "    4: initialisation information.\n");
  printf( " -t do not set system clock and logging (test mode).\n");
  if (err > 0) exit(err);
  return;
}

int main(int argc, char **argv)
{
  int opt;
  int pid;
  
  command = argv[0];
  pid= getpid();
  
  while((opt= getopt(argc, argv, "p:l:s:d:th")) != -1)
    switch(opt)
      {
      case 's':
	if (1<=sscanf(optarg, "port:%i,%i,%i", &port, &portbit, &invertbit));
	else usage(1);
	break;
	
      case 'd':
	sscanf(optarg, "%i", &debug);
	break;
	
      case 't':
	settime= FALSE; /* don't set time */
        logging= FALSE; /* don't log to logfile */
	break;
	
      case 'l':
	logfile= optarg;
	break;
	
      case 'p':
	pidfile= optarg;
	break;
	
      case 'h':
	usage(0);
	exit(0);
	
      default:
	usage(1);
	
      }
  
  /* if we set sysclk log pid */
  
  if(settime==TRUE) 
    /* if the user wants to set his clock,
       do locking and logging. */
    {
      if (access(pidfile,0)==0)
	{
	  fprintf(stderr,"The pidfile \"%s\" exists, failed to run.\n",
		  pidfile );
	  exit(1);
	}
      else
	{
	  if((fp_data= fopen(pidfile, "w"))!=NULL)
	    {
	      fprintf(fp_data,"%d\n",pid);
	      fflush(fp_data);
	      fclose(fp_data);
	    }
	  else
	    {
	      fprintf(stderr, "cannot open dcf77 pidfile: \"%s\".\n", pidfile);
	      exit(1);
	    }
	}
    }
  
  if(logging==TRUE)
    {
      if((fp_data= fopen(logfile, "a"))!=NULL) 
	{
	  fprintf(fp_data,"dcf77 version: %d.%d.%d with pid: %d started.\n"
		  ,VERSION ,SUB_VERSION ,REVISION ,pid);
	  fflush(fp_data);
	}
      else
	{
	  fprintf(stderr, "cannot open logfile: \"%s\".\n",logfile);
	  exit(1);
	}
    }
  
  if (debug>3)
    {  
      printf("commandline processing finished\n");
      printf("dcf77 version: %d.%d.%d with pid: %d started.\n"
	     ,VERSION ,SUB_VERSION ,REVISION ,pid);
    }
  
  dcf_poll();
  
  return 0;
}
