/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: dbs_poweron.c 1.3 Sat, 07 Nov 1998 01:47:54 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include <std/process.h>
#include <std/signal.h>
#include <std/errlog.h>
#include "../api/dbs.h"

int	sigtimer()
{
	signal(SIGALRM, sigtimer);
}

int poweron(int slot)
{
	DBSMSG	msg[128];
	int	status;
	int	tone, port;

	printf("Power-on channel %d %s\n", slot, dbs_getslotid(slot));
	if(dbs_poweron(slot))
	{
		dbs_shutdown();
		errexit(EX_CONFIG, "...send failed");
	}
	for(;;)
	{
		alarm(2);
		status = dbs_recv(msg);
		alarm(0);
		if(status)
		{
			dts_syslog(slot, TLOG_DEBUG, "failed");
			printf("...timeout; failed\n");
			break;
		}

		if(dbs_getslot(msg) != slot)
			continue;
		
		if(dbs_service(msg, &status))
			continue;

		if(status)
		{
			dts_syslog(slot, TLOG_DEBUG, "out of service");
			printf("...out of service\n");
		}
		else
		{
			dts_syslog(slot, TLOG_DEBUG, "startup");
			printf("...online\n");
		}
		break;
	}
}
	
int main(int argc, char **argv)
{
	int	status, opt;
	int	slot = -1;
	bool	usage = FALSE;

	while(EOF != (opt = getopt(argc, argv, "s:")))
		switch(opt)
		{
		case 's':
			slot = 0;
			dbs_setslots(optarg);
			if(dbs_getslots() != 1)
				errexit(EX_CONFIG, "dbs_poweron: %s: unknown channel id", optarg);
			break;
		default:
			usage = TRUE;
		}

	if(usage || optind != argc)
		errexit(EX_USAGE, "use: dbs_poweron [-s slotid]");

	status = dbs_connect(NULL);
	signal(SIGALRM, sigtimer);

	if(status)
		errexit(EX_CONFIG, "dbs_poweron: cannot connect");

	if(dts_syslog(-1, TLOG_DEBUG, "user channel test startup"))
	{
		dbs_shutdown();
		errexit(EX_CONFIG, "dbs_poweron: no server");
	}

	if(slot == -1)
	{
		printf("SET ACD\n");
		dbs_setslots(strdup("acd0 acd1 acd2 acd3 acd4 acd5 acd6 acd7"));
		for(slot = 0; slot < 8; ++slot)
			poweron(slot);
	
		printf("SET VM\n");
		dbs_setslots(strdup("vm0 vm1 vm2 vm3 vm4 vm5 vm6 vm7"));
		for(slot = 0; slot < 8; ++slot)
			poweron(slot);

		printf("SET AA\n");
		dbs_setslots(strdup("aa0 aa1 aa2 aa3 aa4 aa5 aa6 aa7"));
		for(slot = 0; slot < 8; ++slot)
			poweron(slot);
	}
	else
		poweron(0);

	dts_syslog(-1, TLOG_DEBUG, "user channel test complete");
	dbs_shutdown();
	exit(0);
}

