/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: syslog.c 1.2 Fri, 09 Oct 1998 20:59:32 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/string.h>
#include <std/signal.h>
#include <std/syslog.h>
#include <std/time.h>
#include <std/files.h>
#include "server.h"
#include "chars.h"

void	dbs_syslog(uchar *msg)
{
	int	level = msgtype(msg);

	switch(level - '0')
	{
	case TLOG_DEBUG:
		level = LOG_DEBUG;
		break;
	case TLOG_INFO:
		level = LOG_INFO;
		break;
	case TLOG_WARNING:
		level = LOG_WARNING;
		break;
	default:
		level = LOG_ERR;
		break;
	}

	if(msg[2] == 0xff && msg[3] == 0xff)
		syslog(level, "%s", msg + 16);
	else
		syslog(level, "%s(%d,%d) %s", msg
			+ 6, msg[2], msg[3], msg + 16);
}
