/* DBS Telephoy Server (c) 1997-1998 Tycho Softworks.
 * $Id: sockio.c 1.8 Mon, 26 Oct 1998 00:32:12 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/socket.h>
#include <std/select.h>
#include <std/stream.h>
#include "server.h"

#define	MAXAPID	4
#define	MAXVTID	8

static	SOCKET	papi = -1;

typedef	struct
{
	enum
	{
		CS_IDLE = 0,
		CS_INITIAL,
		CS_ACTIVE,
		CS_EXPIRED,
		CS_STOPPING,
		CS_FAILED,
		CS_OFFLINE
	}	status;
	char	appname[10];
	uchar	apid, vtid, flags;
	struct	sockaddr_in	addr;
	unsigned long	seq_read, seq_write;
}	CHANNEL;

static	CHANNEL	channels[MAXAPID][MAXVTID];

static	uchar	pmxsum(uchar *msg, int len)
{
	uchar	sum = 0;
	while(len--)
		sum ^= *(msg++);

	return sum;
}

static	bool	ipcmp(struct sockaddr_in *addr1, struct sockaddr_in *addr2)
{
	if(addr1->sin_family != addr2->sin_family)
		return FALSE;

	if(addr1->sin_port != addr2->sin_port)
		return FALSE;

	if(memcmp(&addr1->sin_addr, &addr2->sin_addr, sizeof(struct in_addr)))
		return FALSE;

	return TRUE;
}

int	initpmx(char *bind, ushort port)
{
	char	*p, **u;
	int	ap, vt;
	struct	servent	*svc;
#ifdef	SO_LINGER
	struct	linger	l = { 0, 0};
#endif

	memset(&channels, 0, sizeof(channels));
	for(ap = 0; ap < MAXAPID; ++ap)
		for(vt = 0; vt < MAXVTID; ++vt)
		{
			channels[ap][vt].apid = ap;
			channels[ap][vt].vtid = vt;
		}

	if(port == 0xffff)
	{
		svc = getservbyname("papi", "udp");
		if(!svc)
			return -1;
		port = ntohs(svc->s_port);
	}
	papi = mksocket(bind, port, SOCK_DGRAM);
	if(papi < 0)
		return papi;
#ifdef	SO_LINGER
	setsockopt(papi, SOL_SOCKET, SO_LINGER, &l, sizeof(l));
#endif
	return 0;
}

void	endpmx(void)
{
	endsocket(papi);
}

int	anybuf(uchar *msg, uchar flag)
{
	uchar	apid, vtid;
	CHANNEL	*ch;

	for(apid = 0; apid < MAXAPID; ++apid)
		for(vtid = 0; vtid < MAXVTID; ++vtid)
		{
			ch = &channels[apid][vtid];
			if(ch->status != CS_ACTIVE)
				continue;

			if(flag && (ch->flags & flag) != flag)
				continue;

			msg[2] = apid;
			msg[3] = vtid;
			putbuf(msg);
			return 0;
		}

	return -1;
}

void	setflags(uchar apid, uchar vtid, uchar flags)
{
	if(apid > MAXAPID || vtid > MAXVTID)
		return;

	channels[apid][vtid].flags |= flags;
}

void	clrflags(uchar apid, uchar vtid, uchar flags)
{
	if(apid > MAXAPID || vtid > MAXVTID)
		return;

	channels[apid][vtid].flags &= ~flags;
}	

int	putall(uchar *msg, uchar flag)
{
	uchar	apid, vtid;
	CHANNEL	*ch;
	int	err = 0;

	for(apid = 0; apid < MAXAPID; ++apid)
		for(vtid = 0; vtid < MAXVTID; ++vtid)
		{
			ch = &channels[apid][vtid];
			if(ch->status != CS_ACTIVE)
				continue;

			if(flag)
				if((flag & ch->flags) != flag)
					continue;

			msg[2] = apid;
			msg[3] = vtid;
			if(putpmx(msg))
				--err;
		}

	return err;
}				

int	putpmx(uchar *msg)
{
	CHANNEL	*ch;
	uchar	mbuf[128];
	uchar	*tail;
	int	alen = sizeof(struct sockaddr_in);
	ulong	seq;

	if(msg[2] > MAXAPID || msg[3] > MAXVTID)
		return -1;

	ch = &channels[msg[2]][msg[3]];
	if(ch->status != CS_INITIAL && ch->status != CS_ACTIVE)
		return -1;

	seq = htonl(ch->seq_write);
	memcpy(mbuf, msg, msglen(msg));
	tail = mbuf + msglen(msg);
	tail[0] = pmxsum(mbuf, msglen(msg));
	memcpy(tail + 1, &seq, 4);

	switch(msgtype(msg))
	{
	case DBS_SERVICE_MSGTYPE:
		if(!msg[6])
		{
			ch->status = CS_ACTIVE;
			ch->flags = 0;
		}
		else
		{
			ch->status = CS_OFFLINE;
			freetp(msg);
		}
		break;
	default:
		if(ch->status == CS_INITIAL)
			return 0;
	}

	/* SENDONLY flag skips actual send				*/

	if(ch->flags & FLAG_SENDONLY)
		return 0;

	++ch->seq_write;
	return sendto(papi, mbuf, msglen(mbuf) + 5, 0, &ch->addr, alen);
}	

uchar	*getpmx(void)
{
	struct	sockaddr_in	addr;
	int	len, mlen, alen;
	uchar	*tail, verify[5];
	CHANNEL	*ch;
	int	i;

	static	uchar	msg[128];

	alen = sizeof(addr);
	memset(&addr, 0, alen);
	mlen = recvfrom(papi, msg, 128, 0, &addr, &alen);
	if(mlen < 11)
		return NULL;

	len = msglen(msg);
	tail = msg + len;
	if(mlen != len + 5)
		return NULL;
	
	verify[0] = pmxsum(msg, len);
	if(tail[0] != verify[0])
		return NULL;

	switch(msg[0])
	{
	case 1:
		if(msg[2] == 0xff && msg[3] == 0xff)
			return msg;
		if(msg[2] > MAXAPID || msg[3] > MAXVTID)
			return NULL;
		return msg;
	default:
		if(msg[2] > MAXAPID || msg[3] > MAXVTID)
			return NULL;	
	}

	ch = &channels[msg[2]][msg[3]];

	switch((long)msgtype(msg) | (long)(msg[0] * 0x10000l))
	{
	case DBS_POWERON_MSGTYPE:
		if(msglen(msg) < 24)
			break;

		if(strncmp(password, msg + 16, 8))
			return NULL;

		if(ch->status != CS_IDLE)
		{
			if(strcmp(ch->appname, "user"))
				if(strncmp(ch->appname, msg + 6, 10))
					return NULL;
			freetp(msg);
		}

		strcpy(ch->appname, msg + 6);
		memcpy(&ch->addr, &addr, alen);
		ch->status = CS_INITIAL;
		ch->seq_read = ch->seq_write = 0;
		msg[1] = 6;		
		break;
	case DBS_MONITOR_MSGTYPE:
		if(!ipcmp(&ch->addr, &addr))
			return NULL;
	
		if(ch->status != CS_ACTIVE)
			return NULL;

		if(locktp(msg))
			return NULL;
		
		break;
	default:
		if(!ipcmp(&ch->addr, &addr))
			return NULL;

		if(ch->status != CS_ACTIVE)
			return NULL;	
	}		
	return msg;
}
	
