/* DBS Telephoy Server (c) 1997-1998 Tycho Softworks.
 * $Id: server.h 1.6 Thu, 22 Oct 1998 20:58:25 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#define	__DBS_SERVER__

#include <std/thread.h>
#include <std/files.h>
#include <std/select.h>
#include <std/time.h>
#include <dbs.h>

extern	int	maxburst, maxsize, maxsegs;
extern	int	clients, stations, trunks, digits;
extern	int	debug;
extern	int	select_timer, read_timer, write_timer, cache_timer;
extern	pthread_t	select_thread, client_thread;
extern	char	*password;

#define	msglen(msg) (msg[1])
#define	msgtype(msg) ((msg[4] << 8) | msg[5])

#define	setbit(x, b)	(x |= (1 << (b + 1)))
#define	getbit(x, b)	(x & (1 << (b + 1)))
#define	clrbit(x, b)	(x &= ~(1 << (b + 1)))

void	down(int excode);
uchar	pkgsum(uchar *msg);
void	initbuf(int size);
uchar	*getbuf(void);
void	putbuf(char *uchar);
uchar	*peekbuf(void);
fd_t	getapi(const char *device, int speed);
void	endapi(void);
ssize_t	sendapi(uchar *buf, size_t len, int timeout);
ssize_t	recvapi(uchar *buf, size_t len, int timeout);
void	armapi(void);
void	trigapi(void);
int	cgetapi(int timeout);
int	cputapi(uchar ch, int timeout);
int	initpmx(char *bind, ushort port);
void	endpmx(void);
uchar	*getpmx(void);
int	putpmx(uchar *msg);
int	putall(uchar *msg, uchar flag);
int	anybuf(uchar *msg, uchar flag);
int	locktp(uchar *msg);
void	freetp(uchar *msg);
void	setflags(uchar apid, uchar vtid, uchar flags);
void	clrflags(uchar apid, uchar vtid, uchar flags);
void	dbs_maint(void);
void	*dbs_client(void *);
void	*dbs_select(void *);
void	dbs_getpapi(void);
void	dbs_putpapi(void);
void	dbs_getpkt(void);
void	dbs_putpkt(void);
void	dbs_syslog(uchar *msg);

