/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: server.c 1.2 Thu, 22 Oct 1998 20:58:25 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/signal.h>
#include <std/process.h>
#include <std/keydata.h>
#include <std/string.h>
#include <std/errlog.h>
#include <std/syslog.h>
#include <std/rt.h>
#include "server.h"

#define	FACILITIES	(sizeof(logs) / sizeof(FACILITY))

typedef	struct
{
	char	*logname;
	int	logid;
}	FACILITY;	

static	FACILITY	logs[] =
{
	{"daemon", LOG_DAEMON},
	{"local0", LOG_LOCAL0},
	{"local1", LOG_LOCAL1},
	{"local2", LOG_LOCAL2},
	{"local3", LOG_LOCAL3},
	{"local4", LOG_LOCAL4},
	{"local5", LOG_LOCAL5},
	{"local6", LOG_LOCAL6},
	{"local7", LOG_LOCAL7}
};

pthread_t	select_thread, client_thread;

int	clients = 0;
int	debug = 0;
int	maxburst = 8, maxsize, maxsegs;
int	select_timer, read_timer, write_timer, cache_timer;
int	stations = 96, trunks = 64, digits = 3;
char	*password;

void	down(int excode)
{
	int	str;

	pthread_cancel(select_thread);
	pthread_join(select_thread, NULL);
	pthread_cancel(client_thread);
	pthread_join(client_thread, NULL);
	endapi();
	endpmx();

	if(excode)
		syslog(LOG_ERR, "terminating; reason code=%d", excode);
	else
		syslog(LOG_INFO, "shutdown");
	closelog();
	exit(excode);
}

static	sigdown()
{
	down(-1);
}

int	main(int argc, char **argv)
{
	static	char	cfgname[80] = "api";

	int	opt, i, pri = -1, logid;
	bool	usage = FALSE;
	bool	daemon = FALSE;
	char	*log;
	fd_t	dev;
	char	*name;
	sigset_t sigs;
	ushort	port = 0xffff;
	char	*bind = "127.0.0.1";
	fd_t	pd = -1;
	char	pdbuf[12];
	char	*pidfile;

	while(EOF != (opt = getopt(argc, argv, "c:x:p:D")))
		switch(opt)
		{
		case 'p':
			pri = atoi(optarg);
			break;
		case 'c':
			strcpy(cfgname, optarg);
			break;
		case 'x':
			debug = atoi(optarg);
			break;
		case 'D':
			daemon = TRUE;
			break;
		default:
			usage = TRUE;
		}

	if(optind != argc)
		usage = TRUE;

	if(usage)
		errexit(EX_USAGE, "use: dbs_server [-ccfgfile]");

	if(getkeyset("/etc/dbs/common"))
	{
		bind = dupkeydata("host", bind);
		port = (ushort)getkeyvalue("port", port);
		switch(getkeyvalue("size", 0))
		{
		case 832:
		case 40:
			stations = 32;
			trunks = 16;
			break;
		case 72:
			stations = 64;
			trunks = 32;
			break;
		case 96:
			stations = 80;
			trunks = 32;
			break;
		}
		stations = getkeyvalue("stations", stations);
		trunks = getkeyvalue("trunks", trunks);
		digits = getkeyvalue("digits", 3);
		password = getkeydata("password", "9999");
	}

	if(!getkeyset(cfgname))
		errexit(EX_CONFIG, "dbs_server: dbs.conf or [api] missing");

	log = getkeydata("syslog", "daemon");
	initbuf(getkeyvalue("buffers", 16));
	maxburst = getkeyvalue("burst", 8);
	maxsize = getkeyvalue("size", 200);
	maxsegs = getkeyvalue("segments", 8);
	select_timer = getkeyvalue("selecttimer", 30);
	read_timer = getkeyvalue("readtimer", 2);
	write_timer = getkeyvalue("writetimer", 2);
	cache_timer = 60 * getkeyvalue("cachetimer", 10);
	bind = getkeydata("bind", bind);
	port = (ushort)getkeyvalue("port", port);

	if(pri < 0)
		pri = getkeyvalue("priority", 0);

	for(opt = 0; opt < FACILITIES; ++opt)
		if(!stricmp(logs[opt].logname, log))
			break;

	if(opt >= FACILITIES)
		errexit(EX_CONFIG, "dbs_server: %s: unknown syslog facility", log);
		
	logid = logs[opt].logid;
	if(initpmx(bind, port))
		errexit(EX_NOPERM, "dbs_server: %s: cannot bind", bind);

	name = getkeydata("device", "/dev/dbs");
	if(getapi(name, getkeyvalue("speed", 9600)) < 0)
	{
		endpmx();
		errexit(EX_NOPERM, "dbs_server: %s: cannot access", name);
	}

	pidfile = getkeydata("pidfile", "/var/run/dbs_server.pid");
	if(pidfile)
	{
		remove(pidfile);
		pd = creat(pidfile, 0660);
	}	

	endkeydata();
	if(daemon)
	{
		close(0);
		close(1);
		close(2);
		pdetach();
	}
	opt = 0;
	if(!daemon)
		opt |= LOG_PERROR;

	if(debug)
		opt |= LOG_PID;

	openlog("dbs_server", opt, logid);
	syslog(LOG_INFO, "startup");

	if(pd > -1)
	{
		sprintf(pdbuf, "%d\n", getpid());
		write(pd, pdbuf, strlen(pdbuf));
		close(pd);
	}

	rtlock();
	rt(pri);

	sigemptyset(&sigs);
	sigaddset(&sigs, SIGALRM);
	sigaddset(&sigs, SIGPIPE);
	sigaddset(&sigs, SIGHUP);
	sigaddset(&sigs, SIGINT);
	sigaddset(&sigs, SIGTERM);
	sigprocmask(SIG_BLOCK, &sigs, NULL);
	signal(SIGINT, sigdown);
	signal(SIGTERM, sigdown);

	pthread_create(&select_thread, NULL, dbs_select, NULL);
	pthread_create(&client_thread, NULL, dbs_client, NULL);
	
	sigemptyset(&sigs);
	sigaddset(&sigs, SIGINT);
	sigaddset(&sigs, SIGTERM);
	pthread_sigmask(SIG_UNBLOCK, &sigs, NULL);
	dbs_maint();
	down(0);
}

