/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: serial.c 1.2 Sun, 11 Oct 1998 20:20:08 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/signal.h>
#include <std/termios.h>
#include <std/errno.h>
#include <std/string.h>
#include <std/signal.h>
#include "server.h"

static	int	timeout;
static	fd_t	dev;
static	pthread_t	iothread;
static	bool	armed	= FALSE;
	
static	int	sigtimer()
{
	++timeout;
	signal(SIGALRM, sigtimer);
}

void	armapi(void)
{
	timeout = 0;
	iothread = pthread_self();
	armed = TRUE;
}

void	trigapi(void)
{
	if(armed)
	{
		armed = FALSE;
		pthread_kill(iothread, SIGALRM);
	}
}

fd_t	getapi(const char *device, int speed)
{
	struct	termios	t;

	dev = open(device, O_RDWR, O_NONBLOCK);
	if(dev < 0)
		return dev;

	if(!isatty(dev))
	{
		close(dev);
		errno = ENODEV;
		return -1;
	}

	tcgetattr(dev, &t);
	t.c_oflag = 0;
	t.c_lflag = 0;
	t.c_iflag = 0;
	t.c_cflag = CLOCAL | CREAD | HUPCL | CS8 | PARENB;
	memset(t.c_cc, 0, sizeof(t.c_cc));
	t.c_cc[VMIN] = 1;
	
	switch(speed)
	{
	case 19200:
		speed=B19200;
		break;
	default:
		speed=B9600;
	}

        cfsetispeed(&t, speed);
        cfsetospeed(&t, speed);

        tcsetattr(dev, TCSANOW, &t);
        fcntl(dev, F_SETFL, O_RDWR);
	signal(SIGALRM, sigtimer);
        return dev;
}

void	endapi(void)
{
	alarm(2);
	tcdrain(dev);
	tcflush(dev, TCIOFLUSH);
	close(dev);
	signal(SIGALRM, SIG_DFL);
}

ssize_t	recvapi(uchar *buf, size_t len, int timer)
{
	ssize_t	got;
	struct	termios	termios;

	if(!armed)
		timeout = 0;
	tcgetattr(dev, &termios);
	termios.c_cc[VMIN] = len;
	tcsetattr(dev, TCSANOW, &termios);
	alarm(timer);
	if(timeout)
	{
		alarm(0);
		armed = FALSE;
		return -1;
	}
	timeout = 0;
	got = read(dev, buf, len);
	alarm(0);
	armed = FALSE;
	return got;
}

ssize_t	sendapi(uchar *buf, size_t len, int timeout)
{
	ssize_t got;
	
	timeout = 0;
	alarm(timeout);
	got = write(dev, buf, len);
	if(got < len)
	{
		alarm(0);
		return got;
	}	
	tcdrain(dev); 
	alarm(0);
	if(timeout)
	{
		errno = EINTR;
		return -1;
	}
	return got;
}

int	cgetapi(int timer)
{
	uchar	buf;
	int	status;

	if(recvapi(&buf, 1, timer) < 1)
		return EOF;

	return buf;
}

int	cputapi(uchar buf, int timer)
{
	return sendapi(&buf, 1, timer);
}

