/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: select.c 1.2 Sun, 11 Oct 1998 20:20:08 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/string.h>
#include <std/signal.h>
#include <std/syslog.h>
#include <std/time.h>
#include "server.h"
#include "chars.h"

void	*dbs_select(void *arg)
{
	static	uchar	selmsg[2] = {CHR_SELECT_API, CHR_SELECT_ENQ};

	uchar	buf;
	bool	selecting = FALSE;
	time_t	heartbeat, now;
	int	ch;
	sigset_t	sigs;

	sigemptyset(&sigs);
	sigaddset(&sigs, SIGALRM);
	pthread_sigmask(SIG_UNBLOCK, &sigs, NULL);

	time(&heartbeat);
	for(;;)
	{
		armapi();
		switch((ch = cgetapi(select_timer)))
		{
		case CHR_SELECT_DBS:
			break;
		case CHR_SELECT_ENQ:
			if(selecting)
			{
				selecting = FALSE;
				break;
			}			
			if(cputapi(CHR_SELECT_ACK, write_timer) != 1)
				break;

			dbs_getpkt();
		case EOF:
			selecting = FALSE;
			if(peekbuf())
			{
				selecting = TRUE;
				sendapi(&selmsg, 2, write_timer);		
			}			
			break;
		case CHR_SELECT_NAK:
			if(selecting)
				break;

			syslog(LOG_WARNING, "unsolicited NAK");
			break;
		case CHR_SELECT_ACK:
			selecting = FALSE;
			if(!peekbuf())
			{
				syslog(LOG_WARNING, "unsolicited ACK");
				break;
			}
			time(&heartbeat);

			dbs_putpkt();
			break;
		default:
			/* syslog(LOG_WARNING, "unsolicited data %02x", ch);
			   unsolicited message */	
		}

		time(&now);
		if(clients && heartbeat)
		{
			if(now >= heartbeat + 300)	
			{
				heartbeat = 0;
				syslog(LOG_WARNING, "no avtivity");
			}
		}
	}		
	return NULL;
}
		
