/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: putpkt.c 1.1 Sat, 19 Sep 1998 20:57:22 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/string.h>
#include <std/syslog.h>
#include <std/time.h>
#include "server.h"
#include "chars.h"

static	uchar	ack	= CHR_REPLY_ACK1;

static	void	dbs_sendpkt(uchar *pkt, uchar len)
{
	int	iolen;
	int	retry = 2;
	int	ch;

	pkt[0] = CHR_PACKET_STX;
	pkt[1] = pkt[2] = 0;
	pkt[3] = len;
	pkt[len + 4] = CHR_PACKET_ETX;
	pkt[len + 5] = pktsum(pkt + 1);
	while(retry--)
	{
		iolen = sendapi(pkt, len + 6, write_timer);
		if(iolen < len + 6)
		{
			syslog(LOG_ERR, "short packet send; %d vs %d", iolen, len);
			continue;
		}
		switch((ch = cgetapi(read_timer)))
		{
		case EOF:
			syslog(LOG_ERR, "no response to send");
			break;
		case CHR_REPLY_ACK1:
		case CHR_REPLY_ACK0:
			if(ch == ack)
				retry = 0;
			else
				syslog(LOG_ERR, "send out of phase");
			break;
		case CHR_REPLY_NAK:
			syslog(LOG_ERR, "invalid checksum in send");
			break;
		default:
			syslog(LOG_ERR, "unknown response to send; %02x", ch);
			break;
		}
	}
	if(ack == CHR_REPLY_ACK1)
		ack = CHR_REPLY_ACK0;
	else
		ack = CHR_REPLY_ACK1;
}

void	dbs_putpkt(void)
{
	uchar	buf[262];
	uchar	mlen = 0;
	int	segs = 0;
	uchar	*msg = buf + 4;
	int	burst = maxburst;
	int	len;	

	ack	= CHR_REPLY_ACK1;
	while(peekbuf() && burst-- > 0)
	{
		len = msglen(peekbuf());
		if(segs++ > maxsegs || mlen + len > maxsize)
		{
			dbs_sendpkt(buf, mlen);
			msg = buf + 4;
			segs = 0;
			mlen = 0;
		}
		memcpy(msg, getbuf(), len);
		msg += len;
		mlen += len;
	}
	if(mlen)
		dbs_sendpkt(buf, mlen);

	cputapi(CHR_SELECT_EOT, write_timer);
}	
