/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: maint.c 1.3 Sun, 11 Oct 1998 20:20:08 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/string.h>
#include <std/select.h>
#include <std/syslog.h>
#include <std/time.h>
#include "server.h"
#include "chars.h"

#define	EXT_LEVEL	0	/* level (tp mode) set to		*/
#define	EXT_ERROR	1	/* error flag				*/
#define	EXT_APID	2
#define	EXT_VTID	3

typedef	struct
{
	ushort	port;
	uchar	status[4];
}	EXTDIR;

typedef	struct
{
	enum
	{
		INQ_INITIAL=0,
		INQ_AVAIL,
		INQ_ERROR
	}	status;

	EXTDIR	*ext;
	ushort	query[3];
	uchar	msg[32];	
}	INQCACHE;

static	INQCACHE	*inqcache;
static	EXTDIR		*extdir;
static	int	extmax = 600;
static	bool	active = FALSE;
static	int	lastport = 0;

static	int	dbs_inquire(int port)
{
	return -1;
}

static	int	getext(uchar *msg)
{
	int	offset;

	if(msg[2] != 0xff)
		return -1;

	if((msg[0] & 0xf0) > 0x90)
		return -1;

	if((msg[0] & 0x0f) > 0x09)
		return -1;

	offset = (msg[0] / 16) * 10 + (msg[0] & 0x0f);

	if(digits == 2)
	{
		if(msg[1] != 0xff)
			return -1;
		offset -= 10;
		if(offset > extmax)
			return -1;
		return offset;
	}

	if((msg[1] & 0x0f) != 0x0f)
		return -1;
	
	if((msg[1] & 0xf0) > 0x90)
		return -1;

	offset = offset * 10 + (msg[1] / 16) - 100;
	if(offset > extmax)
		return -1;
	return offset;
}
	
void	freetp(uchar *msg)
{
	int	offset;
	EXTDIR	*ext;

	for(offset = 0; offset < extmax; ++offset)
	{
		ext = &extdir[offset];	
		if(!ext->status[EXT_LEVEL])
			continue;

		if(ext->status[EXT_APID] != msg[2])
			continue;

		if(ext->status[EXT_VTID] != msg[3])
			continue;
	
		ext->status[EXT_LEVEL] = 0;
	}
}

int	locktp(uchar *msg)
{
	EXTDIR	*ext;
	int	offset;	
	uchar	level = msg[6];

	if(msgtype(msg) != DBS_MONITOR_MSGTYPE)
		return -1;

	if(msg[7] != 0)
		return -1;

	offset = getext(&msg[9]);
	if(offset < 0)
		return -1;

	ext = &extdir[offset];

	if(ext->status[EXT_ERROR])
		return -1;

	if(ext->status[EXT_LEVEL] != 0)
	{
		if(ext->status[EXT_APID] != msg[2])
			return -1;

		if(ext->status[EXT_VTID] != msg[3])
			return -1;	
	}
	
	ext->status[EXT_APID] = msg[2];
	ext->status[EXT_VTID] = msg[3];
	ext->status[EXT_LEVEL] = level;
	return 0;
}	

void	dbs_maint(void)
{
	fd_set	z;
	struct	timeval	timer;
	int	i;

	inqcache = (INQCACHE *)malloc(stations * sizeof(INQCACHE));
	memset(inqcache, 0, stations * sizeof(INQCACHE));

	if(digits == 2)
		extmax = 60;

	extdir = (EXTDIR *)malloc(extmax * sizeof(EXTDIR));
	memset(extdir, 0, extmax * sizeof(EXTDIR));

	for(;;)
	{
		FD_ZERO(&z);
		timer.tv_usec = 0;
		timer.tv_sec = (cache_timer / stations) + 1;
		select(0, &z, &z, &z, &timer);
		if(!dbs_inquire(lastport))
		{
			if(++lastport >= stations)
			{
				lastport = 0;
				active = TRUE;
			}
		}
	}
}

