/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: getpkt.c 1.2 Sun, 11 Oct 1998 20:20:08 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/string.h>
#include <std/syslog.h>
#include <std/time.h>
#include "server.h"
#include "chars.h"

void	dbs_getpkt(void)
{
	uchar	buf[262];
	uchar	eot = CHR_SELECT_EOT;
	uchar	nak = CHR_REPLY_NAK;
	uchar	ack = CHR_REPLY_ACK1;
	int	len;
	uchar	mlen;
	uchar	*msg;
	int	opt;

	for(;;)
	{
		switch((opt = cgetapi(read_timer)))
		{
		case EOF:
			return;
		case CHR_PACKET_STX:
			break;
		case CHR_SELECT_EOT:
			return;
		default:
			syslog(LOG_WARNING, "invalid read start %02x", opt);
			cputapi(CHR_SELECT_EOT, write_timer);
			return;
		}
	
		if(3 != (opt = recvapi(buf, 3, read_timer)))
		{
			syslog(LOG_WARNING, "short read length=%d", opt);
			cputapi(CHR_REPLY_NAK, write_timer);
			continue;
		}

		len = buf[2] + 2;	

		if(len != (opt = recvapi(buf + 3, len, read_timer)))
		{
			syslog(LOG_WARNING, "short packet length=%d", opt);
			cputapi(CHR_REPLY_NAK, write_timer);
			continue;
		}

		len -= 2;
		if(buf[3 + len] != CHR_PACKET_ETX)
		{
			syslog(LOG_WARNING, "invalid read data");
			cputapi(CHR_REPLY_NAK, write_timer);
			continue;
		}

		if(pktsum(buf) != buf[4 + len])
		{
			syslog(LOG_WARNING, "invalid read csum");
			cputapi(CHR_REPLY_NAK, write_timer);
			continue;
		}

		sendapi(&ack, 1, write_timer);
		if(ack == CHR_REPLY_ACK0)
			ack = CHR_REPLY_ACK1;
		else
			ack = CHR_REPLY_ACK0;

		msg = buf + 3;
		while(len > 0)
		{
			switch(msgtype(msg))
			{
			case DBS_APIKEY_MSGTYPE:
				putall(msg, FLAG_KEYMON);
				break;
			default:
				putpmx(msg);
			}

			/* sendmsg */
			mlen = msglen(msg);
			len -= mlen;
			msg += mlen;
		}
	}
}

