/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: client.c 1.2 Sun, 11 Oct 1998 20:20:08 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/thread.h>
#include <std/string.h>
#include <std/signal.h>
#include <std/syslog.h>
#include <std/time.h>
#include <std/files.h>
#include "server.h"
#include "chars.h"

static	void	putdts(uchar *msg)
{
	switch(msgtype(msg))
	{
	case DTS_SETFLAG_MSGTYPE:
		setflags(msg[2], msg[3], msg[6]);
		break;
	case DTS_CLRFLAG_MSGTYPE:
		clrflags(msg[2], msg[3], msg[6]);
		break;
	}
}

void	*dbs_client(void *arg)
{
	uchar	*msg;

	for(;;)
	{
		msg = getpmx();
		if(msg)
		{
			switch(msg[0])
			{
			case 0:
				putbuf(msg);
				break;
			case 1:
				dbs_syslog(msg);
				break;
			case 2:
				putdts(msg);
				break;
			}
		}
	}	
	return NULL;
}
		
