/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: buffer.c 1.1 Sat, 19 Sep 1998 20:57:22 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */
 
#include <std/thread.h>
#include <std/signal.h>
#include <std/string.h>
#include <std/syslog.h>
#include "server.h"

#define	MAXMSG	128

static	int	head = 0, tail = 0, limit;
static	sem_t	shead, stail;
static	pthread_mutex_t	single_post;
static	uchar	*buf;

void	initbuf(int size)
{
	limit = size * MAXMSG;
	sem_init(&shead, 0, 0);
	sem_init(&stail, 0, size - 1);
	pthread_mutex_init(&single_post, NULL);
	buf = (uchar *)malloc(limit);
}

uchar	*peekbuf(void)
{
	if(head == tail)
		return NULL;

	return buf + head;
}

uchar	*getbuf(void)
{
	uchar	*ptr;
	sem_wait(&shead);
	ptr = buf + head;
	if((head += MAXMSG) >= limit)
		head = 0;
	sem_post(&stail);
	return ptr;
}

void	putbuf(char *msg)
{
	uchar	*ptr;
	
	if(pthread_self() == select_thread)
	{
		syslog(LOG_CRIT, "deadlock fault; receiver calling post");
		down(-1);
	}

	pthread_mutex_lock(&single_post);
	sem_wait(&stail);
	ptr = buf + tail;
	memcpy(ptr, msg, msglen(msg));
	if((tail += MAXMSG) >= limit)
		tail = 0;

	sem_post(&shead);
	trigapi();
	pthread_mutex_unlock(&single_post);
}

