/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: syslog.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __STD_SYSLOG_H__
#define __STD_SYSLOG_H__

#ifndef __STD_PROCESS_H__
#include <std/process.h>
#endif

#ifndef SYSLOG_H_MISSING
#include <syslog.h>
#else

#define	LOG_EMERG	0	/* system is unusable */
#define	LOG_ALERT	1	/* action must be taken immediately */
#define	LOG_CRIT	2	/* critical conditions */
#define	LOG_ERR		3	/* error conditions */
#define	LOG_WARNING	4	/* warning conditions */
#define	LOG_NOTICE	5	/* normal but significant condition */
#define	LOG_INFO	6	/* informational */
#define	LOG_DEBUG	7	/* debug-level messages */

#define	LOG_KERN	0x00	/* kernel messages */
#define	LOG_USER	0x10	/* random user-level messages */
#define	LOG_MAIL	0x20	/* mail system */
#define	LOG_DAEMON	0x30	/* system daemons */
#define	LOG_AUTH	0x40	/* security/authorization messages */
#define	LOG_SYSLOG	0x50	/* messages generated internally by syslogd */
#define	LOG_LPR		0x60	/* line printer subsystem */
#define	LOG_NEWS	0x70	/* network news subsystem */
#define	LOG_UUCP	0x80	/* UUCP subsystem */
#define	LOG_CRON	0x90	/* clock daemon */
#define	LOG_AUTHPRIV	0xa0	/* security/authorization messages (private) */

	/* other codes through 15 reserved for system use */
#define	LOG_LOCAL0	0x100	/* reserved for local use */
#define	LOG_LOCAL1	0x110	/* reserved for local use */
#define	LOG_LOCAL2	0x120	/* reserved for local use */
#define	LOG_LOCAL3	0x130	/* reserved for local use */
#define	LOG_LOCAL4	0x140	/* reserved for local use */
#define	LOG_LOCAL5	0x150	/* reserved for local use */
#define	LOG_LOCAL6	0x160	/* reserved for local use */
#define	LOG_LOCAL7	0x170	/* reserved for local use */

#define	LOG_NFACILITIES	24	/* current number of facilities */

#define	LOG_PID		0x01	/* log the pid with each message */
#define	LOG_CONS	0x02	/* log on the console if errors in sending */
#define	LOG_ODELAY	0x04	/* delay open until first syslog() (default) */
#define	LOG_NDELAY	0x08	/* don't delay open */
#define	LOG_NOWAIT	0x10	/* don't wait for console forks: DEPRECATED */
#define	LOG_PERROR	0x20	/* log to stderr as well */

#endif

#ifdef  __cplusplus
extern "C" {
#endif

#ifdef	SYSLOG_H_MISSING
void    openlog(char *ident, int option, int facility);
void    closelog(void);
void    syslog(int priority, const char *fmt, ...)
#endif

int     printlog(const char *path, const char *prefix, const char *fmt, ...);

#ifdef  __cplusplus
}
#endif

#endif
