/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: stream.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_STREAM_H__
#define	__STD_STREAM_H__

#ifndef	__STD_FILES_H__
#include <std/files.h>
#endif

#ifdef	_CAP_UNIX_STREAMS
#include <stropts.h>
#endif

#ifdef	_CAP_UNIX_SOCKETS
#include <sys/un.h>
#include <std/sysid.h>

#ifdef  SCM_RIGHTS
#define __SUN_LEN
#endif

#ifdef	__linux__
#undef	__SUN_LEN
#endif

#ifdef	__FreeBSD__
#ifndef	MSG_ACCRIGHTS_I_MISSING
#define	MSG_ACCRIGHTS_I_MISSING
#endif
#endif

#endif

#ifndef	SYS_UIO_H_MISSING
#include <sys/uio.h>
#else
struct	iovec
{
	void	*iov_base;
	size_t	iov_len;
};

#define	readv		__NAMESPACE(readv)
#define	writev		__NAMESPACE(writev)
#endif

#ifdef	UIO_MAXIOV
#define	MAX_IOVEC	UIO_MAXIOV
#endif

#ifdef	IOV_MAX
#define	MAX_IOVEC	IOV_MAX
#endif

#ifndef	MAX_IOVEC
#define	MAX_IOVEC	16
#endif

#ifdef	_CAP_STREAM_FILES
#define	mkstream	__NAMESPACE(mkstream)
#define	newstream	__NAMESPACE(newstream)
#define	getstream	__NAMESPACE(getstream)
#define	stream		__NAMESPACE(stream)
#endif

#define	readn		__NAMESPACE(readn)
#define	writen		__NAMESPACE(writen)
#define	readln		__NAMESPACE(readln)
#define	writeln		__NAMESPACE(writeln)

#ifdef	_CAP_PASSED_FILES

#define	sendfd		__NAMESPACE(sendfd)
#define	recvfd		__NAMESPACE(recvfd)

#endif

#ifdef	_CAP_PTY_DEVICES
#define	pty_stream	__NAMESPACE(pty_stream)
#define	pty_create	__NAMESPACE(pty_create)
#define	pty_open	__NAMESPACE(pty_open)
#endif

#ifdef	SYS_UIO_H_MISSING
ssize_t	readv(fd_t so, const struct iovec *iov, size_t count);
ssize_t	writev(fd_t so, const struct iovec *iov, size_t count);
#endif

#ifdef	_CAP_PTY_DEVICES
fd_t	pty_create(char *name);
fd_t	pty_open(char *name);
fd_t	pty_device(const char *name, int mode);
#endif

#ifdef	_CAP_STREAM_FILES
fd_t	mkstream(const char *name, int mode);
fd_t	mkdevice(const char *name, int mode);
fd_t	getstream(const char *name);
fd_t	newstream(fd_t stream);
int	stream(fd_t fd[2]);
#endif

ssize_t	readn(fd_t so, char *buf, size_t count);
ssize_t writen(fd_t so, char *buf, size_t count);
ssize_t readln(fd_t so, char *buf, size_t request);
ssize_t writeln(fd_t so, char *buf, size_t limit);

#ifdef	_CAP_PASSED_FILES

int	sendfd(fd_t so, fd_t fd);
fd_t	recvfd(fd_t so);

#endif
#ifdef	__cplusplus
}
#endif

#endif

