/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: socket.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_SOCKET_H__
#define	__STD_SOCKET_H__

#ifndef	__STD_FILES_H__
#include <std/files.h>
#endif

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef	__TCPD__
#include <tcpd.h>
#endif

typedef	int	SOCKET;
#define	INVALID_SOCKET	-1

#ifdef	__cplusplus
extern "C" {
#endif

#define	init_sockets	__NAMESPACE(init_sockets)
#define	endsocket	__NAMESPACE(endsocket)
#define	getsocket	__NAMESPACE(getsocket)
#define	newsocket	__NAMESPACE(newsocket)
#define	mksocket	__NAMESPACE(mksocket)
#define	gethostinfo	__NAMESPACE(gethostinfo)
#define	gethostaddr	__NAMESPACE(gethostaddr)
#define	strpeername	__NAMESPACE(strpeername)
#define	strpeeraddr	__NAMESPACE(strpeeraddr)
#define	strhomename	__NAMESPACE(strhomename)
#define	strhomeaddr	__NAMESPACE(strhomeaddr)
#define	sockident	__NAMESPACE(sockident)
#define	sendln		__NAMESPACE(sendln)
#define	recvln		__NAMESPACE(recvln)

bool	init_sockets(void);
void	endsocket(SOCKET so);
SOCKET	newsocket(SOCKET so, struct in_addr *);
SOCKET	getsocket(const char *hostname, short port, int type);
SOCKET	mksocket(const char *hostname, short port, int type);
struct	hostent	*gethostinfo(const char *hostname);
struct	in_addr	*gethostaddr(const char *hostname, struct in_addr *);
char	*strhomename(SOCKET so);
char	*strhomeaddr(SOCKET so);
char	*strpeername(SOCKET so);
char	*strpeeraddr(SOCKET so);
char	*sockident(SOCKET so);
ssize_t	recvln(SOCKET so, char *buf, size_t len);
ssize_t	sendln(SOCKET so, char *buf, size_t len);

#ifdef	__cplusplus
}
#endif

#endif
