/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: signal.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_SIGNAL_H__
#define	__STD_SIGNAL_H__

#ifndef	__CONFIG_H__
#include <_config.h>
#endif

#include <signal.h>
#include <setjmp.h>

typedef	void	(*trapfunc_t)(int);

#ifdef	SIGSET_T_MISSING

typedef	unsigned int	sigset_t;

#if defined(BSD) || defined(BSD4_3)

#define	sigemptyset(set)	(*(set) = 0)
#define	sigfillset(set)		(*(set) = ~(sigset_t)0, 0)
#define	sigaddset(set, signo)	(*(set) |= sigmask(signo), 0)
#define	sigdelset(set, signo)	(*(set) &= ~sigmask(signo), 0)
#define	sigismember(seg, signo) ((*(set) & sigmask(signo)) != 0)

#define SIG_BLOCK       1
#define SIG_UNBLOCK     2
#define SIG_SETMASK     3

static int __sigtemp;           /* For the use of sigprocmask */

/* Repeated test of oset != NULL is to avoid "*0". */
#define sigprocmask(how, set, oset)                                     \
        ((__sigtemp =                                                   \
        (((how) == SIG_BLOCK) ?                                         \
                sigblock(0) | *(set) :                                  \
        (((how) == SIG_UNBLOCK) ?                                       \
                sigblock(0) & ~(*(set)) :                               \
        ((how) == SIG_SETMASK ?                                         \
                *(set) : sigblock(0))))),                               \
        ((oset) ? (*(oset ? oset : set) = sigsetmask(__sigtemp)) :      \
                sigsetmask(__sigtemp)), 0)

#endif
#else
#define	_POSIX_SIGNALS
#define	signal	signal_posix
#endif

#define	TRAP_SIGHUP	(1<<SIGHUP)
#define	TRAP_SIGINT	(1<<SIGINT)
#define	TRAP_SIGQUIT	(1<<SIGQUIT)
#define	TRAP_SIGKILL	(1<<SIGKILL)
#define	TRAP_SIGPIPE	(1<<SIGPIPE)
#define	TRAP_SIGTERM	(1<<SIGTERM)

#ifdef	SIGCHLD
#define	TRAP_SIGCHLD	(1<<SIGCHLD)
#endif

#ifdef	SIGCONT
#define	TRAP_SIGCONT	(1<<SIGCONT)
#endif

#ifdef	SIGSTOP
#define	TRAP_SIGSTOP	(1<<SIGSTOP)
#endif

#ifdef	SIGTSTP
#define	TRAP_SIGTSTP	(1<<SIGTSTP)
#endif

#ifdef	SIGIO
#define	TRAP_SIGIO	(1<<SIGIO)
#endif

#ifdef	SIGPOLL
#define	TRAP_SIGPOLL	(1<<SIGPOLL)
#endif

#ifdef	SIGWINCH
#define	TRAP_SIGWINCH	(1<<SIGWINCH)
#endif

#ifdef	SIGPWR
#define	TRAP_SIGPWR	(1<<SIGPWR)
#endif

#ifdef	SIGUSR1
#define	TRAP_SIGUSR1	(1<<SIGUSR1)
#endif

#ifdef	SIGUSR2
#define	TRAP_SIGUSR2	(1<<SIGUSR2)
#endif

#ifdef	SIGIOT
#define	TRAP_SIGIOT	(1<<SIGIOT)
#endif

#ifdef	SIGSETJMP_F_MISSING
#define	sigjmp_buf	jmp_buf
#define	sigsetjmp(j, i)	setjmp(j)
#define	siglongjmp(j, i) longjmp(j, i)
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#define	timer	__NAMESPACE(timer)
#define	trap	__NAMESPACE(trap)
#ifdef	_POSIX_SIGNALS
#define	signal_posix	__NAMESPACE(signal_posix)
#define	signal_intr	__NAMESPACE(signal_intr)
#endif

#ifdef	_POSIX_SIGNALS
trapfunc_t	signal_posix(int signo, trapfunc_t);
trapfunc_t	signal_intr(int signo, trapfunc_t);
#endif
int	trap(long sigmask);
int	timer(int timeout);

#ifdef	__cplusplus
}
#endif

#endif

