/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: process.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_PROCESS_H__
#define	__STD_PROCESS_H__

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#ifndef	__STD_LIMITS_H__
#include <std/limits.h>
#endif

#ifndef	POSIX2_LIM_H_MISSING
#include <posix2_lim.h>
#endif

#ifndef	GETOPT_H_MISSING
#include <getopt.h>
#endif

#ifndef	POSIX_OPT_H_MISSING
#include <posix_opt.h>
#endif

#ifndef	UNISTD_H_MISSING
#include <unistd.h>
#endif

#ifndef	_SC_OPEN_MAX
#ifndef	CONFNAME_H_MISSING
#include <confname.h>
#else
#ifndef	SYSCONF_H_MISSING
#include <sysconf.h>
#endif
#endif
#endif

#ifndef	PROCESS_H_MISSING
#include <process.h>
#endif

#ifndef	WAIT_H_MISSING
#include <wait.h>
#else
#ifndef	SYS_WAIT_H_MISSING
#include <sys/wait.h>
#endif
#endif

#ifndef ENV_H_MISSING
#include <env.h>
#endif

#ifndef	SYSEXITS_H_MISSING
#include <sysexits.h>
#else
#define	EX_OK	0
#define	EX_USAGE	64
#define	EX_DATAERR	65
#define	EX_NOINPUT	66
#define	EX_NOUSER	67
#define	EX_NOHOST	68
#define	EX_UNAVAILABLE	69
#define	EX_SOFTWARE	70
#define	EX_OSERR	71
#define	EX_OSFILE	72
#define	EX_CANTCREAT	73
#define	EX_IOERR	74
#define	EX_TEMPFAIL	75
#define	EX_PROTOCOL	76
#define	EX_NOPERM	77
#define	EX_CONFIG	78
#endif

#ifdef	PID_T_MISSING
#undef	PID_T_MISSING
typedef	int pid_t;
#endif

#ifdef	SPAWN_F_MISSING

/* Define UNIX spawn services and flags	*/

#define	P_NOWAIT	0
#define	P_WAIT		1
#define	P_BACKGROUND	2
#define	P_NOWAITO	3
#define	P_OVERLAY	4

#endif

#ifdef	PATHCONF_F_MISSING
#define	_PC_LINK_MAX	0
#define	_PC_MAX_CANON	1
#define	_PC_MAX_INPUT	2
#define	_PC_NAME_MAX	3
#define	_PC_PATH_MAX	4
#define	_PC_PIPE_BUF	5
#define	_PC_CHOWN_RESTRICTED 6
#define	_PC_NO_TRUNC	7
#define	_PC_VDISABLE	8
#endif

#ifdef	SYSCONF_F_MISSING
#define	_SC_ARG_MAX	0
#define	_SC_CHILD_MAX	1
#define	_SC_CLK_TCK	2
#define	_SC_STREAM_MAX	3
#define	_SC_TZNAME_MAX	4
#define	_SC_OPEN_MAX	5
#define	_SC_NGROUPS_MAX	6
#define	_SC_JOB_CONTROL 7
#define	_SC_SAVED_IDS	8
#endif	

#ifdef	VFORK_F_MISSING
#define	vfork()	fork()
#endif

#ifdef	GETPAGESIZE_F_MISSING
#define	getpagesize()	(size_t)(4096)
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	SPAWN_F_MISSING
#define	spawnv	__NAMESPACE(spawnv)
#define	spawnvp __NAMESPACE(spawnvp)

int	spawnv(const int P_mode, const char *path, char *const argv[]);
int	spawnvp(const int P_mode, const char *path, char *const argv[]);

#endif

#ifdef	SYSCONF_F_MISSING
#define	sysconf	__NAMESPACE(sysconf)

long	sysconf(int name);
#endif

#ifdef	PATHCONF_F_MISSING
#define	pathconf __NAMESPACE(pathconf)
#define	fpathconf __NAMESPACE(fpathconf)

long	pathconf(char *path, int name);
long	fpathconf(int fd, int name);
#endif

#ifdef	GETHOSTNAME_F_MISSING
#define	gethostname __NAMESPACE(gethostname)

int	gethostname(char *buf, size_t size);
#endif

#define	pdetach	__NAMESPACE(pdetach)

int	pdetach(void);

#ifdef	__cplusplus
}
#endif

#endif
